/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view.contribution;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;
import org.simantics.event.ontology.EventResource;
import org.simantics.event.view.contribution.EventLabelRule;
import org.simantics.event.view.preference.EventPrefs;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;

public enum ProjectEventsRule implements ChildRule
{
    INSTANCE;


    public static ProjectEventsRule get() {
        return INSTANCE;
    }

    public Collection<?> getChildrenImpl(ReadGraph graph, Resource project, List<Resource> eventLogs) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        boolean hideInfoEvents = EventPrefs.hideInfoEvents(graph, project);
        boolean hideWarningEvents = EventPrefs.hideWarningEvents(graph, project);
        boolean hideReturnEvents = EventPrefs.hideReturnEvents(graph, project);
        boolean showHiddenEvents = EventPrefs.showHiddenEvents(graph, project);
        boolean showOnlyMilestones = EventPrefs.showOnlyMilestones(graph, project);
        boolean showOnlyActiveEvents = EventPrefs.showOnlyActiveEvents(graph, project);
        ArrayList allEvents = new ArrayList();
        for (Resource log : eventLogs) {
            for (Resource slice : graph.getObjects(log, L0.ConsistsOf)) {
                Collection events = graph.getObjects(slice, L0.ConsistsOf);
                allEvents.addAll(events);
            }
        }
        ArrayList<Resource> result = new ArrayList<Resource>();
        THashMap times = new THashMap();
        Double defaultTime = 0.0;
        for (Resource event : allEvents) {
            Integer severity;
            Resource eventType;
            boolean isMilestone;
            if (showOnlyMilestones && !(isMilestone = graph.hasStatement(event, EVENT.Milestone)) || !showHiddenEvents && graph.hasStatement(event, EVENT.Hidden) || showOnlyActiveEvents && (graph.hasStatement(event, EVENT.Returns) || graph.hasStatement(event, EVENT.ReturnedBy) || graph.hasStatement(event, EVENT.NoReturn)) || hideReturnEvents && graph.hasStatement(event, EVENT.ReturnEvent) && graph.getPossibleObject(event, EVENT.Returns) != null || (eventType = graph.getPossibleObject(event, EVENT.Event_type)) != null && (severity = (Integer)graph.getPossibleRelatedValue(eventType, EVENT.EventType_severity)) != null && (hideInfoEvents && severity >= 600 && severity < 700 || hideWarningEvents && severity >= 700 && severity < 800)) continue;
            Double timeNumeric = EventLabelRule.getTimestamp(graph, event, defaultTime);
            times.put(event, timeNumeric);
            result.add(event);
        }
        Collections.sort(result, new Comparator<Object>((Map)times){
            private final /* synthetic */ Map val$times;
            {
                this.val$times = map;
            }

            @Override
            public int compare(Object o1, Object o2) {
                Double t1 = (Double)this.val$times.get(o1);
                Double t2 = (Double)this.val$times.get(o2);
                return t2.compareTo(t1);
            }
        });
        return result;
    }

    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
        Resource project = (Resource)parent;
        ArrayList<Resource> eventLogs = new ArrayList<Resource>();
        for (Resource activeModel : (Collection)graph.syncRequest((Read)new ObjectsWithType(project, L0X.Activates, SIMU.Model))) {
            for (Resource eventLog : (Collection)graph.syncRequest((Read)new ObjectsWithType(activeModel, EVENT.HasEventLog, EVENT.EventLog))) {
                if (graph.hasStatement(eventLog, EVENT.Hidden)) continue;
                eventLogs.add(eventLog);
                graph.getRelatedValue(eventLog, EVENT.HasModificationCounter, (Binding)Bindings.INTEGER);
            }
        }
        QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
        return this.getChildrenImpl(qc.getIndependentGraph(graph), project, eventLogs);
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        if (!(child instanceof Resource)) {
            return Collections.emptyList();
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return graph.getObjects((Resource)child, L0.PartOf);
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }
}

