/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.event.view;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.comparators.ImmutableLexicalComparable;
import org.simantics.browsing.ui.common.processors.AbstractPrimitiveQueryProcessor;
import org.simantics.browsing.ui.common.processors.ProcessorLifecycle;
import org.simantics.browsing.ui.content.ComparableContext;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;
import org.simantics.event.ontology.EventResource;
import org.simantics.operation.Layer0X;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.workbench.StringMemento;
import org.simantics.views.swt.SimanticsView;

public class EventView
extends SimanticsView {
    private static final String EVENTS_TABLE_MEMENTO_ID = "events";
    private static final String BROWSE_CONTEXT = "http://www.simantics.org/Event-1.2/View/EventBrowseContext";
    private static final String CONTEXT_MENU_ID = "org.simantics.event.view.popup";
    private GraphExplorerComposite eventExplorer;
    private TableComparatorFactory comparator;

    protected Set<String> getBrowseContexts() {
        return Collections.singleton(BROWSE_CONTEXT);
    }

    protected String getContextMenuId() {
        return CONTEXT_MENU_ID;
    }

    protected void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        Column[] COLUMNS = new Column[]{new Column("index", "#", Column.Align.LEFT, 70, "Event Index", false), new Column("timestamp", "Time Stamp", Column.Align.LEFT, 100, "Time Stamp", false), new Column("milestone", "M", Column.Align.LEFT, 24, "Is Milestone?", false), new Column("eventType", "Type", Column.Align.LEFT, 110, "Event Type", false), new Column("returned", "R", Column.Align.LEFT, 24, "Has Event Returned?", false), new Column("tag", "Tag", Column.Align.LEFT, 120, "Tag Name", true, 1), new Column("message", "Message", Column.Align.LEFT, 100, "Message", true, 2), new Column("returnTime", "Return Time", Column.Align.LEFT, 100, "Return Event Time Stamp", false)};
        final Text headerText = new Text(body, 0);
        DisposableListener<String> headerTextListener = new DisposableListener<String>(){

            public void execute(final String result) {
                Display d = headerText.getDisplay();
                if (d.isDisposed()) {
                    return;
                }
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (headerText.isDisposed()) {
                            return;
                        }
                        headerText.setText(result);
                        headerText.getParent().layout();
                    }
                });
            }

            public void exception(Throwable t) {
                Logger.defaultLogError((Throwable)t);
            }
        };
        headerText.addDisposeListener(new DisposeListener((DisposableListener)headerTextListener){
            private final /* synthetic */ DisposableListener val$headerTextListener;
            {
                this.val$headerTextListener = disposableListener;
            }

            public void widgetDisposed(DisposeEvent e) {
                this.val$headerTextListener.dispose();
            }
        });
        headerText.setText("");
        headerText.setBackground(body.getBackground());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)headerText);
        Simantics.getSession().asyncRequest((Read)new UniqueRead<String>(){

            public String getChildrenImpl(ReadGraph graph, Resource project, List<Resource> eventLogs) throws DatabaseException {
                int discardedEvents = 0;
                for (Resource log : eventLogs) {
                    Map slices = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(log));
                    if (slices.isEmpty()) continue;
                    ArrayList keys = new ArrayList(slices.keySet());
                    Collections.sort(keys, AlphanumComparator.COMPARATOR);
                    Integer base = Integer.parseInt((String)keys.get(0));
                    discardedEvents += 64 * base;
                }
                if (discardedEvents > 0) {
                    return String.valueOf(discardedEvents) + " events in chronological order have been automatically discarded from event log";
                }
                return "";
            }

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                EventResource EVENT = EventResource.getInstance((ReadGraph)graph);
                Resource project = Simantics.getProjectResource();
                ArrayList<Resource> eventLogs = new ArrayList<Resource>();
                for (Resource activeModel : (Collection)graph.syncRequest((Read)new ObjectsWithType(project, L0X.Activates, SIMU.Model))) {
                    for (Resource eventLog : (Collection)graph.syncRequest((Read)new ObjectsWithType(activeModel, EVENT.HasEventLog, EVENT.EventLog))) {
                        if (graph.hasStatement(eventLog, EVENT.Hidden)) continue;
                        eventLogs.add(eventLog);
                        graph.getRelatedValue(eventLog, EVENT.HasModificationCounter, (Binding)Bindings.INTEGER);
                    }
                }
                QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                return this.getChildrenImpl(qc.getIndependentGraph(graph), project, eventLogs);
            }
        }, (Listener)headerTextListener);
        this.eventExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter", "maxChildren"}).values(new Object[]{false, false, 5000}), site, body, support, 65538){

            protected void initializeExplorerWithEvaluator(GraphExplorer explorer, ISessionContext context, EvaluatorData data) {
                EvaluatorData.Evaluator eval = data.newEvaluator();
                IMemento m = EventView.this.memento;
                if (EventView.this.comparator != null) {
                    m = new StringMemento();
                    EventView.this.comparator.saveState(EventView.EVENTS_TABLE_MEMENTO_ID, m);
                }
                EventView.this.comparator = new TableComparatorFactory(explorer);
                if (m != null) {
                    EventView.this.comparator.restoreState(EventView.EVENTS_TABLE_MEMENTO_ID, m);
                }
                eval.addComparator((ComparableContextFactory)EventView.this.comparator, 2.0);
                data.addEvaluator(Object.class, eval);
            }
        };
        this.eventExplorer.setBrowseContexts(this.getBrowseContexts());
        this.eventExplorer.setContextMenuId(this.getContextMenuId());
        this.eventExplorer.setColumns(COLUMNS);
        this.eventExplorer.finish();
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.eventExplorer);
        this.attachHeaderListeners(this.eventExplorer);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.comparator != null) {
            this.comparator.saveState(EVENTS_TABLE_MEMENTO_ID, memento);
        }
    }

    private void attachHeaderListeners(GraphExplorerComposite explorer) {
        final Tree tree = (Tree)explorer.getExplorerControl();
        String sortColumn = null;
        if (this.comparator != null) {
            sortColumn = this.comparator.getColumn();
        }
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            final TreeColumn column = treeColumnArray[n2];
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Column c = (Column)column.getData();
                    String key = EventView.this.transformColumn(c.getKey());
                    EventView.this.comparator.setColumn(key);
                    EventView.this.comparator.toggleAscending(key);
                    EventView.this.comparator.refresh();
                    tree.setSortColumn(column);
                    tree.setSortDirection(EventView.this.comparator.isAscending(key) ? 1024 : 128);
                }
            });
            Column c = (Column)column.getData();
            String key = this.transformColumn(c.getKey());
            if (key.equals(sortColumn)) {
                tree.setSortColumn(column);
                tree.setSortDirection(this.comparator.isAscending(key) ? 1024 : 128);
            }
            ++n2;
        }
    }

    private String transformColumn(String key) {
        if ("timestamp".equals(key)) {
            key = "timestampNumeric";
        }
        if ("returnTime".equals(key)) {
            key = "returnTimeNumeric";
        }
        return key;
    }

    public void setFocus() {
        this.eventExplorer.setFocus();
    }

    protected IPropertyPage getPropertyPage() {
        return null;
    }

    public class TableComparatorFactory
    implements ComparableContextFactory {
        private static final String SORTING = "sorting";
        private static final String SORT_COL = "sortCol";
        private static final String COLS = "cols";
        private static final String COL_ASCEND = "ascend";
        UpdateTrigger updateTrigger = new UpdateTrigger();
        private String column = null;
        private Map<String, Boolean> ascendMap = new HashMap<String, Boolean>();

        public TableComparatorFactory(GraphExplorer ge) {
            ge.setPrimitiveProcessor((PrimitiveQueryProcessor)this.updateTrigger);
        }

        public void saveState(String id, IMemento memento) {
            if (id == null) {
                throw new NullPointerException("null id");
            }
            IMemento m = null;
            IMemento[] iMementoArray = memento.getChildren(SORTING);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                if (id.equals(child.getID())) {
                    m = child;
                }
                ++n2;
            }
            if (m == null) {
                m = memento.createChild(SORTING, id);
            }
            if (this.getColumn() != null) {
                m.putString(SORT_COL, this.getColumn());
            }
            block1: for (String columnKey : this.ascendMap.keySet()) {
                IMemento[] iMementoArray2 = m.getChildren(COLS);
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento col = iMementoArray2[n4];
                    if (columnKey.equals(col.getID())) {
                        col.putBoolean(COL_ASCEND, this.isAscending(columnKey));
                        continue block1;
                    }
                    ++n4;
                }
                IMemento col = m.createChild(COLS, columnKey);
                col.putBoolean(COL_ASCEND, this.isAscending(columnKey));
            }
        }

        public void restoreState(String id, IMemento memento) {
            if (id == null) {
                throw new NullPointerException("null id");
            }
            if (!this.hasState(id, memento)) {
                return;
            }
            IMemento[] iMementoArray = memento.getChildren(SORTING);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                if (id.equals(m.getID())) {
                    IMemento[] iMementoArray2 = m.getChildren(COLS);
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento column = iMementoArray2[n4];
                        this.setAscending(column.getID(), column.getBoolean(COL_ASCEND));
                        ++n4;
                    }
                    this.setColumn(m.getString(SORT_COL));
                    break;
                }
                ++n2;
            }
        }

        public boolean hasState(String id, IMemento memento) {
            IMemento[] iMementoArray = memento.getChildren(SORTING);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento m = iMementoArray[n2];
                if (id.equals(m.getID())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void setAscending(String column, Boolean ascending) {
            if (ascending == null) {
                this.ascendMap.remove(column);
            } else {
                this.ascendMap.put(column, ascending);
            }
        }

        public boolean isAscending(String column) {
            return !Boolean.FALSE.equals(this.ascendMap.get(column));
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void toggleAscending(String column) {
            Boolean ascending = this.ascendMap.get(column);
            if (ascending == null) {
                this.ascendMap.put(column, Boolean.TRUE);
            } else {
                this.ascendMap.put(column, ascending == false);
            }
        }

        public void refresh() {
            this.updateTrigger.refresh();
        }

        public String getColumn() {
            return this.column;
        }

        public ComparableContext[] create(NodeQueryManager manager, NodeContext parent, NodeContext[] children) {
            manager.query(parent, UpdateTrigger.KEY);
            if (this.column == null) {
                return null;
            }
            ComparableContext[] result = new ComparableContext[children.length];
            int i = 0;
            while (i < children.length) {
                String label;
                NodeContext child = children[i];
                Labeler labeler = (Labeler)manager.query(child, BuiltinKeys.SELECTED_LABELER);
                int category = labeler != null ? labeler.getCategory() : 0;
                String string = label = labeler != null && this.column != null ? (String)labeler.getLabels().get(this.column) : "";
                if (label == null) {
                    label = "";
                }
                boolean _ascending = this.isAscending(this.column);
                result[i] = new ImmutableLexicalComparable(category, label, child, _ascending){
                    final boolean ascending;
                    {
                        this.ascending = bl;
                    }

                    public int compareTo(ComparableContext arg0) {
                        ImmutableLexicalComparable other = (ImmutableLexicalComparable)arg0;
                        int catDelta = this.getCategory() - other.getCategory();
                        if (!this.ascending) {
                            catDelta = -catDelta;
                        }
                        if (catDelta != 0) {
                            return catDelta;
                        }
                        String label1 = this.getLabel();
                        String label2 = other.getLabel();
                        return !this.ascending ? AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)label2, (Object)label1) : AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)label1, (Object)label2);
                    }
                };
                ++i;
            }
            return result;
        }

        public String toString() {
            return "Event Table Sort";
        }
    }

    public static class UpdateTrigger
    extends AbstractPrimitiveQueryProcessor<Double>
    implements ProcessorLifecycle {
        private Double random = Math.random();
        private Map<NodeContext, PrimitiveQueryUpdater> contexts = new THashMap();
        public static final NodeContext.PrimitiveQueryKey<Double> KEY = new NodeContext.PrimitiveQueryKey<Double>(){

            public String toString() {
                return "TRIGGER";
            }
        };

        public Object getIdentifier() {
            return KEY;
        }

        public void refresh() {
            this.random = Math.random();
            for (Map.Entry<NodeContext, PrimitiveQueryUpdater> entry : this.contexts.entrySet()) {
                entry.getValue().scheduleReplace(entry.getKey(), KEY, (Object)this.random);
            }
        }

        public Double query(PrimitiveQueryUpdater updater, NodeContext context, NodeContext.PrimitiveQueryKey<Double> key) {
            this.contexts.put(context, updater);
            return this.random;
        }

        public String toString() {
            return "UpdateTrigger";
        }

        public void attached(GraphExplorer explorer) {
        }

        public void detached(GraphExplorer explorer) {
            this.clear();
        }

        public void clear() {
            this.contexts.clear();
        }
    }
}

