/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads;

import java.util.concurrent.Executor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.threads.IThreadWorkQueue;

public class SWTThread
implements IThreadWorkQueue,
Executor {
    final Display display;

    public static IThreadWorkQueue getThreadAccess(Display display) {
        return new SWTThread(display);
    }

    public static IThreadWorkQueue getThreadAccess(Widget widget) {
        return new SWTThread(widget.getDisplay());
    }

    public static IThreadWorkQueue getThreadAccess() {
        return new SWTThread(Display.getDefault());
    }

    SWTThread(Display display) {
        this.display = display;
    }

    public Thread asyncExec(Runnable runnable) {
        if (this.display.isDisposed()) {
            return null;
        }
        this.display.asyncExec(runnable);
        return this.display.getThread();
    }

    public boolean syncExec(Runnable runnable) {
        if (this.display.isDisposed()) {
            return false;
        }
        if (this.display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            this.display.syncExec(runnable);
        }
        return true;
    }

    public boolean currentThreadAccess() {
        if (this.display.isDisposed()) {
            return false;
        }
        return this.display.getThread() == Thread.currentThread();
    }

    public Thread getThread() {
        if (this.display.isDisposed()) {
            return null;
        }
        return this.display.getThread();
    }

    public String toString() {
        return "SWT Thread";
    }

    @Override
    public void execute(Runnable command) {
        this.syncExec(command);
    }
}

