/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.TIntProcedure;
import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class TypeHierarchy
extends UnaryQuery<InternalProcedure<IntSet>> {
    private TypeHierarchy(int resource) {
        super(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, int r, CacheEntry parent, QueryProcessor provider, ListenerBase listener, InternalProcedure<IntSet> procedure) {
        TypeHierarchy entry = (TypeHierarchy)provider.typeHierarchyMap.get(r);
        if (entry == null) {
            entry = new TypeHierarchy(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (!entry.isReady()) {
                TypeHierarchy typeHierarchy = entry;
                synchronized (typeHierarchy) {
                    if (!entry.isReady()) {
                        throw new IllegalStateException();
                    }
                }
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<IntSet> procedure) {
        TypeHierarchy entry;
        if (parent == null && listener == null && (entry = (TypeHierarchy)provider.typeHierarchyMap.get(r)) != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return;
        }
        TypeHierarchy.runner(graph, r, parent, provider, listener, procedure);
    }

    @Override
    public UnaryQuery<InternalProcedure<IntSet>> getEntry(QueryProcessor provider) {
        return provider.typeHierarchyMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.typeHierarchyMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.typeHierarchyMap.remove(this.id);
    }

    public IntSet computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final InternalProcedure<IntSet> procedure, boolean store) {
        final IntSet result = new IntSet(provider.querySupport, this.id);
        final TIntProcedure addToResult = new TIntProcedure(){

            public boolean execute(int r) {
                result.add(r);
                return true;
            }
        };
        SuperTypes.queryEach(graph, this.id, provider, this, null, new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet types) {
                types.forEach(addToResult);
                TypeHierarchy.this.addOrSet(graph, result, provider);
                procedure.execute(graph, result);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                procedure.exception(graph, t);
            }
        });
        return result;
    }

    public String toString() {
        return "TypeHierarchy[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrSet(ReadGraphImpl graph, IntSet value, QueryProcessor provider) {
        assert (!this.isReady());
        TypeHierarchy typeHierarchy = this;
        synchronized (typeHierarchy) {
            value.trim();
            this.setResult(value);
            this.setReady();
        }
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<IntSet> procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return null;
        }
        IntSet result = (IntSet)this.getResult();
        procedure.execute(graph, result);
        return result;
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet result) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }
}

