/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.Collection;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.RelationInfo;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.procedure.TripleIntProcedureAdapter;
import org.simantics.db.impl.query.AssertedStatements;
import org.simantics.db.impl.query.BinaryQuery;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionBinaryQuery;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.RelationInfoQuery;
import org.simantics.db.impl.query.SuperRelations;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.TripleIntProcedure;
import org.simantics.db.procedure.ListenerBase;

public final class Statements
extends CollectionBinaryQuery<TripleIntProcedure> {
    static final TripleIntProcedure NOPT = new TripleIntProcedure(){

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }

        @Override
        public void execute(ReadGraphImpl graph, int s, int p, int o) {
        }

        @Override
        public void finished(ReadGraphImpl graph) {
        }
    };
    static final InternalProcedure<IntSet> NOP = new InternalProcedure<IntSet>(){

        @Override
        public void execute(ReadGraphImpl graph, IntSet result) {
        }

        @Override
        public void exception(ReadGraphImpl graph, Throwable throwable) {
        }
    };

    public Statements(int r1, int r2) {
        super(r1, r2);
    }

    static final Statements entry(QueryProcessor processor, int r1, int r2) {
        return (Statements)processor.statementsMap.get(Statements.id(r1, r2));
    }

    static final Collection<Statements> entries(QueryProcessor processor, int r1) {
        return processor.statementsMap.values(r1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, int r1, int r2, CacheEntry parent, ListenerBase listener, TripleIntProcedure procedure) {
        QueryProcessor processor = graph.processor;
        Statements entry = (Statements)processor.statementsMap.get(Statements.id(r1, r2));
        if (entry == null) {
            entry = new Statements(r1, r2);
            entry.setPending();
            entry.clearResult(processor.querySupport);
            entry.putEntry(processor);
            processor.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (entry.isPending()) {
                Statements statements = entry;
                synchronized (statements) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            processor.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, int r1, int r2, QueryProcessor provider, CacheEntry parent, ListenerBase listener, TripleIntProcedure procedure) {
        assert (r1 != 0);
        assert (r2 != 0);
        if (parent == null && listener == null) {
            Statements.computeForEach(graph, r1, r2, null, procedure);
            return;
        }
        Statements.runner(graph, r1, r2, parent, listener, procedure);
    }

    @Override
    public BinaryQuery<TripleIntProcedure> getEntry(QueryProcessor provider) {
        return provider.statementsMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.statementsMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.statementsMap.remove(this.id);
    }

    private static final IntArray getAssertionMap(ReadGraphImpl graph, int r1, int r2, Statements entry) {
        class AssertionMapProc
        implements IntProcedure {
            boolean first = true;
            private IntArray result;
            private final /* synthetic */ int val$r2;
            private final /* synthetic */ Statements val$entry;

            AssertionMapProc(int n, Statements statements) {
                this.val$r2 = n;
                this.val$entry = statements;
            }

            public void addStatement(int s, int p, int o) {
                if (this.result.size() == 0) {
                    this.result.add(s);
                    this.result.add(p);
                    this.result.add(o);
                } else {
                    int i = 0;
                    while (i < this.result.sizeOrData) {
                        int existingO;
                        int existingP = this.result.data[i + 1];
                        if (p == existingP && (existingO = this.result.data[i + 2]) == o) {
                            return;
                        }
                        i += 3;
                    }
                    this.result.add(s);
                    this.result.add(p);
                    this.result.add(o);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) {
                AssertedStatements stms = AssertedStatements.queryEach(graph, type, this.val$r2, graph.processor, this.val$entry, null, NOPT);
                if (this.result == null) {
                    this.result = (IntArray)stms.getResult();
                } else {
                    int i;
                    IntArray ia;
                    if (this.first) {
                        ia = this.result;
                        this.result = new IntArray();
                        if (ia.data != null) {
                            i = 0;
                            while (i < ia.sizeOrData) {
                                this.addStatement(ia.data[i], ia.data[i + 1], ia.data[i + 2]);
                                i += 3;
                            }
                        }
                        this.first = false;
                    }
                    ia = (IntArray)stms.getResult();
                    if (ia.data != null) {
                        i = 0;
                        while (i < ia.sizeOrData) {
                            this.addStatement(ia.data[i], ia.data[i + 1], ia.data[i + 2]);
                            i += 3;
                        }
                    }
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable throwable) {
            }
        }
        AssertionMapProc amp = new AssertionMapProc(r2, entry);
        PrincipalTypes.queryEach(graph, r1, graph.processor, entry, null, amp);
        return amp.result;
    }

    private static final void forSingleAssertion(ReadGraphImpl graph, int r1, int r2, Statements entry, TripleIntProcedure procedure) {
        IntArray map = Statements.getAssertionMap(graph, r1, r2, entry);
        if (map == null) {
            if (entry != null) {
                entry.finish(graph, procedure);
            } else {
                procedure.finished(graph);
            }
            return;
        }
        int size = map.size();
        if (size == 3) {
            int s = map.data[0];
            int p = map.data[1];
            int o = map.data[2];
            if (entry != null) {
                entry.addOrSetFunctional(s, p, o);
                entry.finish(graph, procedure);
            } else {
                procedure.execute(graph, s, p, o);
                procedure.finished(graph);
            }
        } else if (size == 0) {
            if (entry != null) {
                entry.finish(graph, procedure);
            } else {
                procedure.finished(graph);
            }
        } else {
            int candidateS = map.data[0];
            int candidateP = map.data[1];
            int candidateO = map.data[2];
            SuperTypes candidate = SuperTypes.queryEach(graph, candidateS, graph.processor, entry, null, NOP);
            if (candidate.isExcepted()) {
                if (entry != null) {
                    entry.except((Throwable)candidate.getResult());
                }
                procedure.exception(graph, (Throwable)candidate.getResult());
                return;
            }
            IntSet candidateIs = (IntSet)candidate.getResult();
            int i = 3;
            while (i < map.size()) {
                int nextS = map.data[i];
                int nextP = map.data[i + 1];
                int nextO = map.data[i + 2];
                if (nextS != candidateS && !candidateIs.contains(nextS)) {
                    SuperTypes next = SuperTypes.queryEach(graph, nextS, graph.processor, entry, null, NOP);
                    if (next.isExcepted()) {
                        if (entry != null) {
                            entry.except((Throwable)next.getResult());
                        }
                        procedure.exception(graph, (Throwable)next.getResult());
                        return;
                    }
                    IntSet nextIs = (IntSet)next.getResult();
                    if (nextIs.contains(candidateS)) {
                        candidateS = nextS;
                        candidateP = nextP;
                        candidateO = nextO;
                        candidateIs = nextIs;
                    } else {
                        ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has conflicting assertions.", r1);
                        if (entry != null) {
                            entry.except(exception);
                        }
                        procedure.exception(graph, exception);
                        return;
                    }
                }
                i += 3;
            }
            if (entry != null) {
                entry.addOrSetFunctional(candidateS, candidateP, candidateO);
                entry.finish(graph, procedure);
            } else {
                procedure.execute(graph, candidateS, candidateP, candidateO);
                procedure.finished(graph);
            }
        }
    }

    public static final void computeFunctionalIndex(ReadGraphImpl graph, final int r1, final int r2, final Statements entry, RelationInfo ri, final TripleIntProcedure procedure) {
        if (ri.isFinal) {
            int result = graph.processor.querySupport.getFunctionalObject(r1, r2);
            if (result == 0) {
                Statements.forSingleAssertion(graph, r1, r2, entry, procedure);
            } else if (result == -1) {
                graph.processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int i) {
                        if (Statements.this != null) {
                            Statements.this.addOrSetFunctional(r1, r2, i);
                        } else {
                            procedure.execute(graph, r1, r2, i);
                        }
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                    }
                });
                Statements.forSingleAssertion(graph, r1, r2, entry, procedure);
            } else if (entry != null) {
                entry.addOrSetFunctional(r1, r2, result);
                entry.finish(graph, procedure);
            } else {
                procedure.execute(graph, r1, r2, result);
                procedure.finished(graph);
            }
        } else {
            final AtomicBoolean found = new AtomicBoolean(false);
            DirectPredicates.queryEach(graph, r1, graph.processor, null, null, new SyncIntProcedure(){

                @Override
                public void run(ReadGraphImpl graph) {
                    if (found.get()) {
                        if (entry != null) {
                            entry.finish(graph, procedure);
                        } else {
                            procedure.finished(graph);
                        }
                    } else {
                        Statements.forSingleAssertion(graph, r1, r2, entry, procedure);
                    }
                }

                @Override
                public void execute(ReadGraphImpl graph, final int pred) {
                    if (found.get()) {
                        return;
                    }
                    if (pred == r2) {
                        this.inc();
                        DirectObjects.queryEach(graph, r1, pred, graph.processor, null, null, new IntProcedure(){

                            @Override
                            public void execute(ReadGraphImpl graph, int i) {
                                if (found.compareAndSet(false, true)) {
                                    if (entry != null) {
                                        entry.addOrSetFunctional(r1, pred, i);
                                    } else {
                                        procedure.execute(graph, r1, pred, i);
                                    }
                                } else {
                                    ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one statement.", r1);
                                    if (entry != null) {
                                        entry.except(exception);
                                    }
                                    procedure.exception(graph, exception);
                                }
                            }

                            @Override
                            public void finished(ReadGraphImpl graph) {
                                this.dec(graph);
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) {
                                procedure.exception(graph, t);
                                this.dec(graph);
                            }
                        });
                    } else {
                        this.inc();
                        SuperRelations.queryEach(graph, pred, graph.processor, entry, null, new InternalProcedure<IntSet>(){

                            @Override
                            public void execute(ReadGraphImpl graph, IntSet result) {
                                if (found.get()) {
                                    this.dec(graph);
                                    return;
                                }
                                if (result.contains(r2)) {
                                    this.inc();
                                    DirectObjects.queryEach(graph, r1, pred, graph.processor, null, null, new IntProcedure(){

                                        @Override
                                        public void execute(ReadGraphImpl graph, int i) {
                                            if (found.compareAndSet(false, true)) {
                                                if (entry != null) {
                                                    entry.addOrSetFunctional(r1, pred, i);
                                                } else {
                                                    procedure.execute(graph, r1, pred, i);
                                                }
                                            } else {
                                                ManyObjectsForFunctionalRelationException exception = new ManyObjectsForFunctionalRelationException("Functional relation has more than one statement.", r1);
                                                if (entry != null) {
                                                    entry.except(exception);
                                                }
                                                procedure.exception(graph, exception);
                                            }
                                        }

                                        @Override
                                        public void finished(ReadGraphImpl graph) {
                                            this.dec(graph);
                                        }

                                        @Override
                                        public void exception(ReadGraphImpl graph, Throwable t) {
                                            procedure.exception(graph, t);
                                            this.dec(graph);
                                        }
                                    });
                                }
                                this.dec(graph);
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) {
                                procedure.exception(graph, t);
                                this.dec(graph);
                            }
                        });
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    this.dec(graph);
                }
            });
        }
    }

    private static final void forAssertions(ReadGraphImpl graph, int r1, final int r2, Statements entry, final TripleIntProcedure procedure) {
        PrincipalTypes.queryEach(graph, r1, graph.processor, entry, null, new SyncIntProcedure(){
            TripleIntProcedure proc;
            {
                this.proc = new TripleIntProcedureAdapter(){

                    @Override
                    public void execute(ReadGraphImpl graph, int s, int p, int o) {
                        if (Statements.this != null) {
                            Statements.this.addOrSet(s, p, o);
                        } else {
                            tripleIntProcedure.execute(graph, s, p, o);
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        this.dec(graph);
                        tripleIntProcedure.exception(graph, t);
                    }
                };
            }

            @Override
            public void run(ReadGraphImpl graph) {
                if (Statements.this != null) {
                    Statements.this.finish(graph, procedure);
                } else {
                    procedure.finished(graph);
                }
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) {
                this.inc();
                AssertedStatements.queryEach(graph, type, r2, graph.processor, Statements.this, null, this.proc);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                this.dec(graph);
            }
        });
    }

    public static final void computeNotFunctionalIndex(ReadGraphImpl graph, final int r1, final int r2, final Statements entry, RelationInfo ri, final TripleIntProcedure procedure) {
        if (ri.isFinal) {
            graph.processor.querySupport.getObjects(graph, r1, r2, new IntProcedure(){

                @Override
                public void execute(ReadGraphImpl graph, int i) {
                    if (Statements.this != null) {
                        Statements.this.addOrSet(r1, r2, i);
                    } else {
                        procedure.execute(graph, r1, r2, i);
                    }
                }

                @Override
                public void exception(ReadGraphImpl graph, Throwable t) {
                    procedure.exception(graph, t);
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                }
            });
            if (ri.isAsserted) {
                Statements.forAssertions(graph, r1, r2, entry, procedure);
            } else if (entry != null) {
                entry.finish(graph, procedure);
            } else {
                procedure.finished(graph);
            }
        } else {
            DirectPredicates.queryEach(graph, r1, graph.processor, null, null, new SyncIntProcedure(){

                @Override
                public void run(ReadGraphImpl graph) {
                    Statements.forAssertions(graph, r1, r2, entry, procedure);
                }

                @Override
                public void execute(ReadGraphImpl graph, final int pred2) {
                    if (pred2 == r2) {
                        this.inc();
                        DirectObjects.queryEach(graph, r1, pred2, graph.processor, null, null, new IntProcedure(){

                            @Override
                            public void execute(ReadGraphImpl graph, int i) {
                                if (entry != null) {
                                    entry.addOrSet(r1, pred2, i);
                                } else {
                                    procedure.execute(graph, r1, pred2, i);
                                }
                            }

                            @Override
                            public void finished(ReadGraphImpl graph) {
                                this.dec(graph);
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) {
                                procedure.exception(graph, t);
                                this.dec(graph);
                            }
                        });
                    } else {
                        try {
                            IntSet result = SuperRelations.queryEach2(graph, pred2, graph.processor, entry, null, null);
                            if (result.contains(r2)) {
                                this.inc();
                                DirectObjects.queryEach(graph, r1, pred2, graph.processor, null, null, new IntProcedure(){

                                    @Override
                                    public void execute(ReadGraphImpl graph, int i) {
                                        if (entry != null) {
                                            entry.addOrSet(r1, pred2, i);
                                        } else {
                                            procedure.execute(graph, r1, pred2, i);
                                        }
                                    }

                                    @Override
                                    public void finished(ReadGraphImpl graph) {
                                        this.dec(graph);
                                    }

                                    @Override
                                    public void exception(ReadGraphImpl graph, Throwable t) {
                                        procedure.exception(graph, t);
                                        this.dec(graph);
                                    }
                                });
                            }
                        }
                        catch (Throwable e) {
                            procedure.exception(graph, e);
                        }
                    }
                }

                @Override
                public void finished(ReadGraphImpl graph) {
                    this.dec(graph);
                }
            });
        }
    }

    @Override
    public void computeForEach(ReadGraphImpl graph, QueryProcessor provider, TripleIntProcedure procedure, boolean store) {
        Statements.computeForEach(graph, this.r1(), this.r2(), this, procedure);
    }

    public static void computeForEach(ReadGraphImpl graph, final int r1, final int r2, final Statements entry, final TripleIntProcedure procedure) {
        RelationInfoQuery riEntry = RelationInfoQuery.probe(graph, r2);
        if (riEntry != null) {
            RelationInfo ri = (RelationInfo)riEntry.getResult();
            graph.ensureLoaded(r1, r2);
            if (ri.isFunctional) {
                Statements.computeFunctionalIndex(graph, r1, r2, entry, ri, procedure);
            } else {
                Statements.computeNotFunctionalIndex(graph, r1, r2, entry, ri, procedure);
            }
            return;
        }
        RelationInfoQuery.queryEach(graph, r2, graph.processor, entry, null, new InternalProcedure<RelationInfo>(){

            @Override
            public void execute(ReadGraphImpl graph, RelationInfo ri) {
                graph.ensureLoaded(r1, r2);
                if (ri.isFunctional) {
                    Statements.computeFunctionalIndex(graph, r1, r2, entry, ri, procedure);
                } else {
                    Statements.computeNotFunctionalIndex(graph, r1, r2, entry, ri, procedure);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                procedure.exception(graph, t);
            }
        });
    }

    public String toString() {
        return "Statements[" + this.r1() + " - " + this.r2() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finish(ReadGraphImpl graph, TripleIntProcedure procedure) {
        assert (this.assertPending());
        Statements statements = this;
        synchronized (statements) {
            this.setReady();
        }
        IntArray v = (IntArray)this.getResult();
        IntArray value = (IntArray)this.getResult();
        int i = 0;
        while (i < value.size()) {
            procedure.execute(graph, value.data[i], value.data[i + 1], value.data[i + 2]);
            i += 3;
        }
        procedure.finished(graph);
    }

    public synchronized void addOrSet(int s, int p, int o) {
        assert (this.assertPending());
        IntArray value = (IntArray)this.getResult();
        value.add(s);
        value.add(p);
        value.add(o);
    }

    public static final int r1(long id) {
        return (int)(id >>> 32);
    }

    public static final int r2(long id) {
        return (int)id;
    }

    public final void addOrSetFunctional(int s, long po) {
        this.addOrSetFunctional(s, Statements.r1(po), Statements.r2(po));
    }

    public final void addOrSetFunctional(int s, int p, int o) {
        assert (this.assertPending());
        IntArray value = (IntArray)this.getResult();
        value.add(s);
        value.add(p);
        value.add(o);
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, TripleIntProcedure procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return;
        }
        IntArray value = (IntArray)this.getResult();
        int i = 0;
        while (i < value.size()) {
            procedure.execute(graph, value.data[i], value.data[i + 1], value.data[i + 2]);
            i += 3;
        }
        procedure.finished(graph);
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new TripleIntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                new Error("Error in recompute.", t).printStackTrace();
                s.release();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.r1());
    }
}

