/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.RelationInfo;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.Types;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class RelationInfoQuery
extends UnaryQuery<InternalProcedure<RelationInfo>> {
    private RelationInfoQuery(int resource) {
        super(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final RelationInfo runner(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<RelationInfo> procedure) {
        RelationInfoQuery entry = (RelationInfoQuery)provider.relationInfoMap.get(r);
        if (entry == null) {
            entry = new RelationInfoQuery(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
            return (RelationInfo)entry.getResult();
        }
        if (!entry.isReady()) {
            RelationInfoQuery relationInfoQuery = entry;
            synchronized (relationInfoQuery) {
                if (!entry.isReady()) {
                    throw new IllegalStateException();
                }
            }
        }
        provider.performForEach(graph, entry, parent, listener, procedure);
        return (RelationInfo)entry.getResult();
    }

    public static final RelationInfo queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<RelationInfo> procedure) {
        RelationInfoQuery entry = (RelationInfoQuery)provider.relationInfoMap.get(r);
        if (entry != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return (RelationInfo)entry.getResult();
        }
        return RelationInfoQuery.runner(graph, r, provider, parent, listener, procedure);
    }

    public static final RelationInfoQuery probe(ReadGraphImpl graph, int resource) {
        int thread = graph.thread(resource);
        RelationInfoQuery entry = (RelationInfoQuery)graph.processor.relationInfoMap.get(resource);
        if (entry != null && entry.isReady()) {
            return entry;
        }
        return null;
    }

    @Override
    public UnaryQuery<InternalProcedure<RelationInfo>> getEntry(QueryProcessor provider) {
        return provider.relationInfoMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.relationInfoMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.relationInfoMap.remove(this.id);
    }

    private void computeAssertions(ReadGraphImpl graph, final boolean isFinal, final boolean isFunctional, final QueryProcessor queryProvider, final InternalProcedure<RelationInfo> proc) {
        int isUsedInAssertion = queryProvider.getHasPredicateInverse();
        assert (isUsedInAssertion != 0);
        DirectObjects.queryEach(graph, this.id, isUsedInAssertion, queryProvider, this, null, new IntProcedure(){
            AtomicBoolean done = new AtomicBoolean(false);

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                if (this.done.compareAndSet(false, true)) {
                    RelationInfo result = new RelationInfo(RelationInfoQuery.this.id, isFunctional, isFinal, true);
                    RelationInfoQuery.this.addOrSet(graph, result, queryProvider);
                    proc.execute(graph, result);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                if (this.done.compareAndSet(false, true)) {
                    RelationInfo result = new RelationInfo(RelationInfoQuery.this.id, isFunctional, isFinal, false);
                    RelationInfoQuery.this.addOrSet(graph, result, queryProvider);
                    proc.execute(graph, result);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable throwable) {
                if (this.done.compareAndSet(false, true)) {
                    DatabaseException e = new DatabaseException("Internal error in RelationInfoQuery");
                    RelationInfoQuery.this.except(e);
                    proc.exception(graph, e);
                }
            }
        });
    }

    private void computeTypes(ReadGraphImpl graph, final boolean isFinal, final QueryProcessor queryProvider, final InternalProcedure<RelationInfo> proc) {
        Types.queryEach(graph, this.id, queryProvider, this, null, new InternalProcedure<IntSet>(){

            @Override
            public void execute(ReadGraphImpl graph, IntSet types) {
                RelationInfoQuery.this.computeAssertions(graph, isFinal, types.contains(queryProvider.getFunctionalRelation()), queryProvider, proc);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                proc.exception(graph, t);
            }
        });
    }

    @Override
    public Object computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final InternalProcedure<RelationInfo> procedure, boolean store) {
        final int superRelationOf = provider.getSuperrelationOf();
        assert (superRelationOf != 0);
        DirectPredicates.queryEach(graph, this.id, provider, this, null, new IntProcedure(){
            boolean found = false;

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                if (i == superRelationOf) {
                    RelationInfoQuery.this.computeTypes(graph, false, provider, procedure);
                    this.found = true;
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                if (!this.found) {
                    RelationInfoQuery.this.computeTypes(graph, true, provider, procedure);
                }
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                procedure.exception(graph, t);
            }
        });
        return this.getResult();
    }

    public String toString() {
        return "RelationInfoQuery[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrSet(ReadGraphImpl graph, RelationInfo result, QueryProcessor provider) {
        assert (this.isPending());
        RelationInfoQuery relationInfoQuery = this;
        synchronized (relationInfoQuery) {
            this.setResult(result);
            this.setReady();
        }
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<RelationInfo> procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return EXCEPTED;
        }
        RelationInfo result = (RelationInfo)this.getResult();
        procedure.execute(graph, result);
        return result;
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new InternalProcedure<RelationInfo>(){

            @Override
            public void execute(ReadGraphImpl graph, RelationInfo result) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute.", t);
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    public int type() {
        return 1;
    }
}

