/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;

public final class ReadEntry<T>
extends CacheEntryBase {
    protected Read<T> request;

    public ReadEntry(Read<T> request) {
        this.request = request;
    }

    @Override
    int makeHash() {
        return this.request.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }

    @Override
    public void discard() {
        super.discard();
        this.setResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOrSet(AsyncReadGraph graph, Object item) {
        assert (this.assertPending());
        ReadEntry readEntry = this;
        synchronized (readEntry) {
            this.setResult(item);
            this.setReady();
        }
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph_, Object provider, CacheEntry entry) {
                QueryProcessor qp = (QueryProcessor)provider;
                WriteGraphImpl write = (WriteGraphImpl)qp.getCore().getSession().getService(WriteGraphImpl.class);
                WriteGraphImpl graph = write.newSync(entry);
                try {
                    entry.setPending();
                    Object result = ReadEntry.this.request.perform((ReadGraph)graph);
                    ReadEntry.this.addOrSet((AsyncReadGraph)graph, result);
                }
                catch (Throwable t) {
                    ReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor processor) {
                processor.readMap.remove(ReadEntry.this.request);
            }

            @Override
            public int type() {
                return 0;
            }

            public String toString() {
                if (ReadEntry.this.request == null) {
                    return "DISCARDED";
                }
                return String.valueOf(ReadEntry.this.request.toString()) + ReadEntry.this.statusOrException;
            }
        };
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
        AsyncProcedure proc = (AsyncProcedure)procedure;
        if (this.isExcepted()) {
            try {
                proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            try {
                proc.execute((AsyncReadGraph)graph, this.getResult());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public String toString() {
        if (this.request == null) {
            return "DISCARDED";
        }
        return String.valueOf(this.request.toString()) + " - " + this.statusOrException;
    }

    public Object get(ReadGraphImpl graph, QueryProcessor processor, Object procedure) throws DatabaseException {
        if (procedure != null) {
            this.performFromCache(graph, processor, procedure);
        }
        this.checkAndThrow();
        return this.getResult();
    }
}

