/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryIdentityHashSet;
import org.simantics.db.impl.query.QueryProcessor;

class QueryCollectorImpl
implements QueryProcessor.QueryCollector {
    private final QueryProcessor queryProcessor;
    private final QueryProcessor.QueryCollectorSupport support;
    private QueryIdentityHashSet prospects = new QueryIdentityHashSet(10);
    private QueryIdentityHashSet oneParent = new QueryIdentityHashSet(10);
    private ArrayList<CacheEntry> prospectList = new ArrayList();
    private int prospectListPosition = 0;
    private ArrayList<CacheEntry> singleList = new ArrayList();
    private int singleListPosition = 0;
    private QueryIdentityHashSet manyParentsSet = new QueryIdentityHashSet(10);
    boolean doneAll = false;
    boolean moreAll = false;
    boolean doneProspects = false;
    boolean moreProspects = false;
    boolean doneSingle = false;
    boolean moreSingle = false;
    private static final int COLLECT_N = 1000;
    private static final int PROSPECT_N = 5000;
    private static final int SINGLE_N = 5000;
    private static final int RANDOMS = 4096;
    private static final double RANDOM_MAX = 64.0;
    final int[] randoms;

    QueryCollectorImpl(QueryProcessor queryProcessor, QueryProcessor.QueryCollectorSupport support) {
        this.queryProcessor = queryProcessor;
        this.support = support;
        this.randoms = new int[4096];
        int i = 0;
        while (i < 4096) {
            this.randoms[i] = (int)(64.0 * Math.random());
            ++i;
        }
    }

    @Override
    public void collect(int allowedTimeInMs) {
        long start = System.nanoTime();
        int randomCounter = (int)(start & 0xFFFL);
        long test = (long)allowedTimeInMs * 1000000L;
        this.start();
        while (!(System.nanoTime() - start > test || this.doneAll && this.doneProspects && this.doneSingle)) {
            CacheEntry parent;
            CacheEntry entry;
            int i;
            if (!this.doneAll) {
                i = 0;
                while (i < 1000) {
                    entry = this.support.iterate();
                    if (entry == null) {
                        if (!this.moreAll) {
                            this.doneAll = true;
                        }
                        this.moreAll = false;
                        break;
                    }
                    parent = entry.getFirstParent(this.queryProcessor);
                    if (parent == null) {
                        this.addProspect(entry);
                    } else {
                        if (parent.isDiscarded()) {
                            entry.removeParent(parent);
                            parent = entry.getFirstParent(this.queryProcessor);
                            if (parent != null && parent.isDiscarded()) {
                                entry.removeParent(parent);
                                parent = entry.getFirstParent(this.queryProcessor);
                                this.manyParentsSet.add(entry);
                            }
                        }
                        if (parent == null) {
                            this.addProspect(entry);
                        } else {
                            int parentCount = entry.parentCount(this.queryProcessor);
                            if (parentCount == 1) {
                                this.addSingle(entry, parent);
                            } else {
                                if (this.randoms[randomCounter] < parentCount) {
                                    this.manyParentsSet.add(entry);
                                }
                                randomCounter = randomCounter + 1 & 0xFFF;
                            }
                        }
                    }
                    entry.incAge();
                    ++i;
                }
            }
            if (!this.doneProspects) {
                i = 0;
                while (i < 5000) {
                    entry = this.iterateProspect();
                    if (entry == null) {
                        if (!this.moreProspects) {
                            this.doneProspects = true;
                        }
                        this.moreProspects = false;
                        break;
                    }
                    if (entry.isDiscarded()) {
                        this.prospects.remove(entry);
                    } else if (!entry.hasParents()) {
                        if (this.tryCollect(entry)) {
                            this.prospects.remove(entry);
                            this.doneSingle = false;
                            this.moreSingle = true;
                        }
                    } else {
                        this.prospects.remove(entry);
                    }
                    ++i;
                }
            }
            if (!this.doneSingle) {
                i = 0;
                while (i < 5000) {
                    entry = this.iterateSingleParent();
                    if (entry == null) {
                        if (!this.moreSingle) {
                            this.doneSingle = true;
                        }
                        this.moreSingle = false;
                        break;
                    }
                    if (entry.isDiscarded()) {
                        this.oneParent.remove(entry);
                    } else {
                        parent = entry.getFirstParent(this.queryProcessor);
                        if (parent != null) {
                            if (parent.isDiscarded()) {
                                entry.removeParent(parent);
                            }
                            if (!entry.hasParents()) {
                                this.oneParent.remove(entry);
                                if (!this.tryCollect(entry)) {
                                    this.addProspect(entry);
                                }
                            } else if (entry.moreThanOneParent(this.queryProcessor)) {
                                this.oneParent.remove(entry);
                            } else {
                                parent = entry.getFirstParent(this.queryProcessor);
                                int level = entry.setLevel(parent.getLevel() + 1);
                                if (level > 2) {
                                    this.oneParent.remove(entry);
                                }
                            }
                        } else {
                            this.oneParent.remove(entry);
                            if (!this.tryCollect(entry)) {
                                this.addProspect(entry);
                            }
                        }
                    }
                    ++i;
                }
            }
            for (CacheEntry entry2 : this.manyParentsSet) {
                entry2.pruneParents();
                if (System.nanoTime() - start > test) break;
            }
            this.manyParentsSet.clear();
        }
        return;
    }

    private boolean tryCollect(CacheEntry entry) {
        if (!this.queryProcessor.hasListenerAfterDisposing(entry) && entry.shouldBeCollected()) {
            this.queryProcessor.removeQuery(entry);
            this.doneSingle = false;
            this.moreSingle = true;
            return true;
        }
        return false;
    }

    private CacheEntry iterateProspect() {
        if (this.prospectListPosition >= this.prospectList.size()) {
            if (this.prospects.isEmpty()) {
                return null;
            }
            this.prospectList.clear();
            for (CacheEntry prospect : this.prospects) {
                this.prospectList.add(prospect);
            }
            this.prospectListPosition = 0;
            return null;
        }
        return this.prospectList.get(this.prospectListPosition++);
    }

    private CacheEntry iterateSingleParent() {
        if (this.singleListPosition >= this.singleList.size()) {
            if (this.oneParent.isEmpty()) {
                return null;
            }
            this.singleList.clear();
            for (CacheEntry single : this.oneParent) {
                this.singleList.add(single);
            }
            this.singleListPosition = 0;
            return null;
        }
        return this.singleList.get(this.singleListPosition++);
    }

    private void start() {
        this.moreAll = true;
        this.doneAll = false;
        this.moreProspects = false;
        this.doneProspects = false;
        this.moreSingle = false;
    }

    private void addProspect(CacheEntry entry) {
        if (this.prospects.add(entry)) {
            entry.setLevel(0);
            this.moreAll = true;
            this.doneAll = false;
            this.moreProspects = true;
            this.doneProspects = false;
            this.moreSingle = true;
            this.doneSingle = false;
        }
    }

    private void addSingle(CacheEntry entry, CacheEntry parent) {
        int level = parent.getLevel() + 1;
        entry.setLevel(level);
        if (level > 2) {
            return;
        }
        if (this.oneParent.contains(entry)) {
            return;
        }
        if (this.oneParent.size() > 30000) {
            return;
        }
        this.oneParent.add(entry);
        this.doneSingle = false;
    }
}

