/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionUnaryQuery;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.SuperTypes;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class PrincipalTypes
extends CollectionUnaryQuery<IntProcedure> {
    private PrincipalTypes(int resource) {
        super(resource);
    }

    static final PrincipalTypes entry(QueryProcessor provider, int r) {
        return (PrincipalTypes)provider.principalTypesMap.get(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, int r, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        QueryProcessor processor = graph.processor;
        PrincipalTypes entry = (PrincipalTypes)processor.principalTypesMap.get(r);
        if (entry == null) {
            entry = new PrincipalTypes(r);
            entry.setPending();
            entry.clearResult(processor.querySupport);
            entry.putEntry(processor);
            processor.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (entry.isPending()) {
                PrincipalTypes principalTypes = entry;
                synchronized (principalTypes) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            processor.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        assert (r != 0);
        if (parent == null && listener == null) {
            PrincipalTypes.computeForEach(graph, r, null, graph.processor, procedure);
        } else {
            PrincipalTypes.runner(graph, r, parent, listener, procedure);
        }
    }

    @Override
    public UnaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.principalTypesMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.principalTypesMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.principalTypesMap.remove(this.id);
    }

    @Override
    public Object computeForEach(ReadGraphImpl procedureGraph, QueryProcessor provider, IntProcedure proc, boolean store) {
        return PrincipalTypes.computeForEach(procedureGraph, this.id, this, provider, proc);
    }

    public static Object computeForEach(final ReadGraphImpl graph, final int id, final PrincipalTypes entry, final QueryProcessor provider, final IntProcedure proc) {
        provider.querySupport.ensureLoaded(graph, id);
        assert (id != 0);
        int ret = provider.querySupport.getSingleInstance(id);
        if (ret > 0) {
            if (entry != null) {
                entry.add(ret);
                entry.finish(graph, provider);
            }
            proc.execute(graph, ret);
            proc.finished(graph);
            return ret;
        }
        int instanceOf = provider.getInstanceOf();
        int inherits = provider.getInherits();
        int subrelationOf = provider.getSubrelationOf();
        final Koss indirect = new Koss();
        final Koss material = new Koss();
        IntProcedure directProc = new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                material.add(i);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                proc.exception(graph, t);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }
        };
        IntProcedure indirectProc = new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int i) {
                indirect.add(i);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                proc.exception(graph, t);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
            }
        };
        provider.querySupport.getObjects(graph, id, instanceOf, directProc);
        provider.querySupport.getObjects(graph, id, inherits, indirectProc);
        provider.querySupport.getObjects(graph, id, subrelationOf, indirectProc);
        if (indirect.size() == 0) {
            int size = material.size();
            if (size == 0) {
                if (entry != null) {
                    entry.finish(graph, provider);
                }
                proc.finished(graph);
                return null;
            }
            if (size == 1) {
                int single = material.single;
                if (entry != null) {
                    entry.add(single);
                    entry.finish(graph, provider);
                }
                proc.execute(graph, single);
                proc.finished(graph);
                return single;
            }
            PrincipalTypes.addPrincipalType(graph, new TIntHashSet(4), material.toArray(), 0, provider, entry, proc);
            return null;
        }
        final AtomicInteger finishes = new AtomicInteger(0);
        indirect.forEach(new TIntProcedure(){

            public boolean execute(int arg0) {
                if (arg0 == id) {
                    int current = finishes.addAndGet(1);
                    if (current == indirect.size()) {
                        int size = material.size();
                        if (size == 0) {
                            if (entry != null) {
                                entry.finish(graph, provider);
                            }
                            proc.finished(graph);
                            return true;
                        }
                        if (size == 1) {
                            int single = material.single;
                            if (entry != null) {
                                entry.add(single);
                                entry.finish(graph, provider);
                            }
                            proc.execute(graph, single);
                            proc.finished(graph);
                            return true;
                        }
                        PrincipalTypes.addPrincipalType(graph, new TIntHashSet(4), material.toArray(), 0, provider, entry, proc);
                        return true;
                    }
                    return true;
                }
                PrincipalTypes.queryEach(graph, arg0, provider, entry, null, new IntProcedure(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute(ReadGraphImpl graph, int i) {
                        Koss koss = material;
                        synchronized (koss) {
                            material.add(i);
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        int current = finishes.addAndGet(1);
                        if (current == indirect.size()) {
                            int size = material.size();
                            if (size == 0) {
                                if (entry != null) {
                                    entry.finish(graph, provider);
                                }
                                proc.finished(graph);
                                return;
                            }
                            if (size == 1) {
                                int single = material.single;
                                if (entry != null) {
                                    entry.add(single);
                                    entry.finish(graph, provider);
                                }
                                proc.execute(graph, single);
                                proc.finished(graph);
                                return;
                            }
                            PrincipalTypes.addPrincipalType(graph, new TIntHashSet(4), material.toArray(), 0, provider, entry, proc);
                            return;
                        }
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        proc.exception(graph, t);
                    }
                });
                return true;
            }
        });
        return null;
    }

    private static void finish(ReadGraphImpl graph, TIntHashSet rejects, int[] material, PrincipalTypes entry, QueryProcessor provider, IntProcedure proc) {
        int i;
        int n;
        int n2;
        int[] nArray;
        if (entry != null) {
            nArray = material;
            n2 = material.length;
            n = 0;
            while (n < n2) {
                i = nArray[n];
                if (!rejects.contains(i)) {
                    entry.add(i);
                }
                ++n;
            }
            entry.finish(graph, provider);
        }
        nArray = material;
        n2 = material.length;
        n = 0;
        while (n < n2) {
            i = nArray[n];
            if (!rejects.contains(i)) {
                proc.execute(graph, i);
            }
            ++n;
        }
        proc.finished(graph);
    }

    private static void addPrincipalType(ReadGraphImpl graph, final TIntHashSet rejects, final int[] material, int index, final QueryProcessor provider, final PrincipalTypes entry, final IntProcedure proc) {
        if (index == material.length) {
            PrincipalTypes.finish(graph, rejects, material, entry, provider, proc);
            return;
        }
        int type = material[index++];
        while (rejects.contains(type)) {
            if (index == material.length) {
                PrincipalTypes.finish(graph, rejects, material, entry, provider, proc);
                return;
            }
            type = material[index++];
        }
        final int nextIndex = index;
        SuperTypes.queryEach(graph, type, provider, entry, null, new InternalProcedure<IntSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ReadGraphImpl graph, IntSet supers) {
                TIntHashSet tIntHashSet = rejects;
                synchronized (tIntHashSet) {
                    supers.forEach(new TIntProcedure(){

                        public boolean execute(int arg0) {
                            rejects.add(arg0);
                            return true;
                        }
                    });
                }
                PrincipalTypes.addPrincipalType(graph, rejects, material, nextIndex, provider, entry, proc);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                proc.exception(graph, t);
            }
        });
    }

    public String toString() {
        return "PrincipalTypes[" + this.id + "]";
    }

    private final void add(int val) {
        assert (this.isPending());
        IntArray v = (IntArray)this.getResult();
        v.add(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finish(ReadGraphImpl graph, QueryProcessor provider) {
        assert (this.isPending());
        PrincipalTypes principalTypes = this;
        synchronized (principalTypes) {
            this.setReady();
        }
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return EXCEPTED;
        }
        IntArray value = (IntArray)this.getResult();
        if (value.data == null) {
            if (value.sizeOrData != -1) {
                procedure.execute(graph, value.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < value.sizeOrData) {
                procedure.execute(graph, value.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
        return this.getResult();
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }

    @Override
    protected void fillImpliedParents(QueryProcessor processor, ArrayList<CacheEntry> result) {
    }

    static class Koss {
        private TIntHashSet set = null;
        public int single = 0;

        Koss() {
        }

        public boolean add(int val) {
            if (this.single == val) {
                return false;
            }
            if (this.single == 0) {
                this.single = val;
                return true;
            }
            if (this.set == null) {
                this.set = new TIntHashSet(4);
            }
            this.set.add(val);
            return true;
        }

        public int size() {
            if (this.single == 0) {
                return 0;
            }
            if (this.set == null) {
                return 1;
            }
            return this.set.size() + 1;
        }

        public int[] toArray() {
            int[] result = Arrays.copyOf(this.set.toArray(), this.set.size() + 1);
            result[this.set.size()] = this.single;
            return result;
        }

        public void forEach(TIntProcedure proc) {
            proc.execute(this.single);
            if (this.set != null) {
                this.set.forEach(proc);
            }
        }
    }
}

