/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.TIntProcedure;
import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.AssertedPredicates;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.DirectPredicates;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.PrincipalTypes;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class Predicates
extends UnaryQuery<IntProcedure> {
    public Predicates(int r) {
        super(r);
    }

    public static Predicates newInstance(int r) {
        return new Predicates(r);
    }

    static final Predicates entry(QueryProcessor provider, int r) {
        return (Predicates)provider.predicatesMap.get(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, int r, QueryProcessor provider, Predicates cached, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        Predicates entry;
        Predicates predicates = entry = cached != null ? cached : (Predicates)provider.predicatesMap.get(r);
        if (entry == null) {
            entry = new Predicates(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (entry.isPending()) {
                Predicates predicates2 = entry;
                synchronized (predicates2) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final IntSet runner2(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent) throws Throwable {
        Predicates entry = (Predicates)provider.predicatesMap.get(r);
        if (entry == null) {
            entry = new Predicates(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            return (IntSet)provider.performForEach2(graph, entry, parent, null, null);
        }
        if (entry.isPending()) {
            Predicates predicates = entry;
            synchronized (predicates) {
                if (entry.isPending()) {
                    throw new IllegalStateException();
                }
            }
        }
        return (IntSet)provider.performForEach(graph, entry, parent, null, null);
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        assert (r != 0);
        Predicates entry = (Predicates)provider.predicatesMap.get(r);
        if (parent == null && listener == null && entry != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return;
        }
        Predicates.runner(graph, r, provider, entry, parent, listener, procedure);
    }

    public static final IntSet queryEach2(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent) throws Throwable {
        Predicates entry;
        if (parent == null && (entry = (Predicates)provider.predicatesMap.get(r)) != null && entry.isReady()) {
            return (IntSet)entry.get(graph, provider, null);
        }
        return Predicates.runner2(graph, r, provider, parent);
    }

    @Override
    public UnaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.predicatesMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.predicatesMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.predicatesMap.remove(this.id);
    }

    private final void forAssertions(ReadGraphImpl graph, final QueryProcessor queryProvider, final IntProcedure procedure, final boolean store) {
        PrincipalTypes.queryEach(graph, this.id, queryProvider, store ? this : null, null, new SyncIntProcedure(){
            IntProcedure proc;
            {
                this.proc = new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int i) {
                        if (Predicates.this.addOrSet(queryProcessor, i)) {
                            intProcedure.execute(graph, i);
                        }
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        intProcedure.exception(graph, t);
                    }
                };
            }

            @Override
            public void run(ReadGraphImpl graph) {
                Predicates.this.finish(graph, queryProvider);
                procedure.finished(graph);
            }

            @Override
            public void execute(ReadGraphImpl graph, int type) {
                this.inc();
                AssertedPredicates.queryEach(graph, type, queryProvider, store ? Predicates.this : null, null, this.proc);
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        });
    }

    @Override
    public Object computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final IntProcedure procedure, final boolean store) {
        DirectPredicates.queryEach(graph, this.id, provider, store ? this : null, null, new IntProcedure(){

            @Override
            public void execute(ReadGraphImpl graph, int pred) {
                if (Predicates.this.addOrSet(provider, pred)) {
                    procedure.execute(graph, pred);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                Predicates.this.forAssertions(graph, provider, procedure, store);
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                procedure.exception(graph, t);
            }
        });
        return this.getResult();
    }

    public String toString() {
        return "Predicates2[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish(ReadGraphImpl graph, QueryProcessor provider) {
        Predicates predicates = this;
        synchronized (predicates) {
            this.setReady();
        }
    }

    private synchronized boolean addOrSet(QueryProcessor processor, int add) {
        if (!this.isPending()) {
            this.setResult(new IntSet(null));
        }
        IntSet value = (IntSet)this.getResult();
        return value.add(add);
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(new IntSet(support));
    }

    @Override
    public Object performFromCache(final ReadGraphImpl graph, QueryProcessor provider, final IntProcedure procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return EXCEPTED;
        }
        IntSet v = (IntSet)this.getResult();
        if (procedure != null) {
            v.forEach(new TIntProcedure(){

                public boolean execute(int arg0) {
                    procedure.execute(graph, arg0);
                    return true;
                }
            });
            procedure.finished(graph);
        }
        return v;
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new IntProcedure(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute.", t);
            }

            @Override
            public void execute(ReadGraphImpl graph, int i) {
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }

    @Override
    public int type() {
        return 1;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) {
        return graph.processor.isImmutable(this.id);
    }
}

