/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.TObjectIntHashMap;
import java.util.concurrent.Semaphore;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.Objects;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.StringQuery;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.ValueQuery;
import org.simantics.db.procedure.ListenerBase;

public final class NamespaceIndex
extends StringQuery<InternalProcedure<TObjectIntHashMap<String>>> {
    private NamespaceIndex(String id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, String id, QueryProcessor provider, NamespaceIndex cached, CacheEntry parent, ListenerBase listener, InternalProcedure<TObjectIntHashMap<String>> procedure) {
        NamespaceIndex entry;
        NamespaceIndex namespaceIndex = entry = cached != null ? cached : (NamespaceIndex)provider.namespaceIndexMap22.get((Object)id);
        if (entry == null) {
            entry = new NamespaceIndex(id);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (entry.isPending()) {
                NamespaceIndex namespaceIndex2 = entry;
                synchronized (namespaceIndex2) {
                    if (entry.isPending()) {
                        throw new IllegalStateException();
                    }
                }
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, String id, QueryProcessor provider, CacheEntry parent, ListenerBase listener, InternalProcedure<TObjectIntHashMap<String>> procedure) {
        NamespaceIndex entry = (NamespaceIndex)provider.namespaceIndexMap22.get((Object)id);
        if (parent == null && listener == null && entry != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return;
        }
        NamespaceIndex.runner(graph, id, provider, entry, parent, listener, procedure);
    }

    public NamespaceIndex getEntry(QueryProcessor provider) {
        return (NamespaceIndex)provider.namespaceIndexMap22.get((Object)this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.namespaceIndexMap22.put((Object)this.id, (Object)this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.namespaceIndexMap22.remove((Object)this.id);
    }

    private final void index(ReadGraphImpl graph, QueryProcessor provider, int root, final InternalProcedure<TObjectIntHashMap<String>> procedure) {
        if (root == 0) {
            this.add2(graph, null);
            procedure.execute(graph, null);
            return;
        }
        int consistsOf = provider.getConsistsOf();
        final int hasName = provider.getHasName();
        final TObjectIntHashMap result = new TObjectIntHashMap();
        Objects.runner(graph, root, consistsOf, graph.parent, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                if (NamespaceIndex.this.isPending()) {
                    NamespaceIndex.this.add2(graph, (TObjectIntHashMap<String>)result);
                    procedure.execute(graph, result);
                } else {
                    procedure.exception(graph, (Throwable)NamespaceIndex.this.statusOrException);
                }
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }

            @Override
            public void execute(ReadGraphImpl graph, final int obj) {
                this.inc();
                Objects.runner(graph, obj, hasName, graph.parent, null, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int i) {
                        this.inc();
                        ValueQuery.queryEach(graph, i, NamespaceIndex.this, null, new InternalProcedure<byte[]>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void execute(ReadGraphImpl graph, byte[] value) {
                                if (value != null) {
                                    try {
                                        Binding b = WriteBindings.STRING;
                                        Serializer serializer = b.serializer();
                                        String part = (String)serializer.deserialize(value);
                                        TObjectIntHashMap tObjectIntHashMap = result;
                                        synchronized (tObjectIntHashMap) {
                                            Object previous = result.put((Object)URIStringUtils.escape((String)part), obj);
                                            if (previous != null) {
                                                previous = "";
                                            }
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                this.dec(graph);
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) {
                                NamespaceIndex.this.except(t);
                                this.dec(graph);
                            }
                        });
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        NamespaceIndex.this.except(t);
                        this.dec(graph);
                    }
                });
            }
        });
    }

    @Override
    public void computeForEach(ReadGraphImpl graph, final QueryProcessor processor, final InternalProcedure<TObjectIntHashMap<String>> procedure) {
        if ("http://".equals(this.id) || "http:/".equals(this.id)) {
            this.index(graph, processor, processor.getRootLibrary(), procedure);
        } else {
            final String[] parts = URIStringUtils.splitURI((String)this.id);
            if (parts != null) {
                NamespaceIndex.queryEach(graph, parts[0], processor, this, null, new InternalProcedure<TObjectIntHashMap<String>>(){

                    @Override
                    public void execute(ReadGraphImpl graph, TObjectIntHashMap<String> index) {
                        if (index != null) {
                            NamespaceIndex.this.index(graph, processor, index.get((Object)parts[1]), procedure);
                        } else {
                            NamespaceIndex.this.add2(graph, (TObjectIntHashMap<String>)null);
                            procedure.execute(graph, null);
                        }
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        NamespaceIndex.this.except(t);
                        procedure.exception(graph, t);
                    }
                });
            } else {
                this.add2(graph, null);
                procedure.execute(graph, null);
            }
        }
    }

    public String toString() {
        return "NamespaceIndex[" + this.id + "]";
    }

    private synchronized void add(TObjectIntHashMap<String> result) {
        throw new Error("Not possible!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add2(ReadGraphImpl graph, TObjectIntHashMap<String> result) {
        if (!this.isPending()) {
            new Exception("" + this.hashCode()).printStackTrace();
        }
        assert (this.isPending());
        NamespaceIndex namespaceIndex = this;
        synchronized (namespaceIndex) {
            this.setResult(result);
            this.setReady();
        }
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<TObjectIntHashMap<String>> procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return;
        }
        procedure.execute(graph, (TObjectIntHashMap<String>)((TObjectIntHashMap)this.getResult()));
    }

    @Override
    public synchronized void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new InternalProcedure<TObjectIntHashMap<String>>(){

            @Override
            public void execute(ReadGraphImpl graph, TObjectIntHashMap<String> result) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                throw new Error("Error in recompute.", t);
            }
        });
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }
}

