/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.request.MultiRead;

public final class MultiReadEntry<T>
extends CacheEntryBase {
    protected MultiRead<T> request;

    public MultiReadEntry(MultiRead<T> request) {
        this.request = request;
    }

    @Override
    int makeHash() {
        return this.request.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }

    @Override
    public void discard() {
        super.discard();
        this.request = null;
        this.setResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finish(AsyncReadGraph graph) {
        assert (this.isPending());
        Object p = null;
        MultiReadEntry multiReadEntry = this;
        synchronized (multiReadEntry) {
            this.setReady();
        }
    }

    @Override
    public final void clearResult(QuerySupport support) {
        this.setResult(new ArrayList());
    }

    public final synchronized void addOrSet(Object item) {
        assert (this.isPending());
        ArrayList value = (ArrayList)this.getResult();
        value.add(item);
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
                QueryProcessor qp = (QueryProcessor)provider;
                ReadGraphImpl parentGraph = ReadGraphImpl.forRecompute(entry, qp);
                try {
                    MultiReadEntry.this.request.perform((ReadGraph)parentGraph, new AsyncMultiProcedure<T>(){

                        public void execute(AsyncReadGraph graph, T result) {
                            MultiReadEntry.this.addOrSet(result);
                        }

                        public void finished(AsyncReadGraph graph) {
                            MultiReadEntry.this.finish(graph);
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            MultiReadEntry.this.except(t);
                        }
                    });
                }
                catch (Throwable t) {
                    MultiReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor processor) {
                processor.multiReadMap.remove(MultiReadEntry.this.request);
            }

            @Override
            public int type() {
                return 0;
            }

            public String toString() {
                if (MultiReadEntry.this.request == null) {
                    return "DISCARDED";
                }
                return String.valueOf(MultiReadEntry.this.request.toString()) + MultiReadEntry.this.statusOrException;
            }
        };
    }

    public void performFromCache(AsyncReadGraph graph, Object provider, Object procedure) {
        AsyncMultiProcedure proc = (AsyncMultiProcedure)procedure;
        if (this.isExcepted()) {
            try {
                proc.exception(graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            ArrayList values = (ArrayList)this.getResult();
            for (Object value : values) {
                try {
                    proc.execute(graph, value);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            try {
                proc.finished(graph);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
        AsyncMultiProcedure proc = (AsyncMultiProcedure)procedure;
        if (this.isExcepted()) {
            try {
                proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            ArrayList values = (ArrayList)this.getResult();
            for (Object value : values) {
                try {
                    proc.execute((AsyncReadGraph)graph, value);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            try {
                proc.finished((AsyncReadGraph)graph);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public String toString() {
        if (this.request == null) {
            return "DISCARDED";
        }
        return String.valueOf(this.request.toString()) + this.statusOrException;
    }
}

