/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.LinkedList;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.ExternalRead;

public final class ExternalReadEntry<T>
extends CacheEntryBase {
    final LinkedList<T> items = new LinkedList();
    protected ExternalRead<T> request;

    @Override
    int makeHash() {
        return this.request.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.request;
    }

    @Override
    public void clearResult(QuerySupport support) {
    }

    @Override
    public void discard() {
        this.request.unregistered();
        this.request = null;
        super.discard();
    }

    public ExternalReadEntry(ExternalRead<T> request) {
        assert (request != null);
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queue(T item) {
        LinkedList<T> linkedList = this.items;
        synchronized (linkedList) {
            this.items.addLast(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOrSet(QueryProcessor processor, Object item) {
        try {
            assert (this.isPending());
            Object p = null;
            ExternalReadEntry externalReadEntry = this;
            synchronized (externalReadEntry) {
                this.setResult(item);
                this.setReady();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
                QueryProcessor qp = (QueryProcessor)provider;
                LinkedList linkedList = ExternalReadEntry.this.items;
                synchronized (linkedList) {
                    if (!ExternalReadEntry.this.items.isEmpty()) {
                        ExternalReadEntry.this.setResult(ExternalReadEntry.this.items.removeFirst());
                    }
                    if (!ExternalReadEntry.this.items.isEmpty()) {
                        qp.updatePrimitive(ExternalReadEntry.this.request);
                    }
                }
                ExternalReadEntry.this.setReady();
            }

            @Override
            public void removeEntry(QueryProcessor processor) {
                processor.externalReadMap.remove(ExternalReadEntry.this.request);
            }

            @Override
            public int type() {
                return 1;
            }

            public String toString() {
                if (ExternalReadEntry.this.request == null) {
                    return "DISCARDED ExternalRead";
                }
                return ExternalReadEntry.this.request.toString();
            }
        };
    }

    public void performFromCache(Object procedure) {
        Procedure proc = (Procedure)procedure;
        if (this.isExcepted()) {
            proc.exception((Throwable)this.getResult());
        } else {
            proc.execute(this.getResult());
        }
    }

    public String toString() {
        if (this.request == null) {
            return "DISCARDED ExternalRead " + System.identityHashCode(this);
        }
        return String.valueOf(this.request.toString()) + " " + System.identityHashCode(this);
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
        this.performFromCache(procedure);
    }
}

