/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import gnu.trove.THash;
import java.lang.reflect.Array;
import org.simantics.db.impl.query.DoubleKeyValueMap;

public abstract class DoubleKeyQueryHash<Procedure>
extends THash {
    static final long serialVersionUID = -3461112548087185871L;
    protected transient DoubleKeyValueMap<Procedure>[] _set;
    protected final DoubleKeyValueMap<Procedure> REMOVED = new DoubleKeyValueMap(-1);

    public DoubleKeyQueryHash() {
        super(10, 0.75f);
    }

    protected int capacity() {
        return this._set.length;
    }

    protected void removeAt(int index) {
        this._set[index] = this.REMOVED;
        super.removeAt(index);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = (DoubleKeyValueMap[])Array.newInstance(DoubleKeyValueMap.class, capacity);
        return capacity;
    }

    protected int index(int id) {
        DoubleKeyValueMap<Procedure>[] set = this._set;
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DoubleKeyValueMap<Procedure> cur = set[index];
        if (cur == null) {
            return -1;
        }
        if (cur == this.REMOVED || id != cur.id) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || id != cur.id));
        }
        return cur == null ? -1 : index;
    }

    protected final DoubleKeyValueMap<Procedure> index2(int id) {
        DoubleKeyValueMap<Procedure>[] set = this._set;
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DoubleKeyValueMap<Procedure> cur = set[index];
        if (cur == null) {
            return null;
        }
        if (cur == this.REMOVED || id != cur.id) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || id != cur.id));
        }
        return cur;
    }

    protected int insertionIndex(int id) {
        DoubleKeyValueMap<Procedure>[] set = this._set;
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DoubleKeyValueMap<Procedure> cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.id) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.id);
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.id)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    protected int insertionIndex2(int id, DoubleKeyValueMap<Procedure>[] set) {
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DoubleKeyValueMap<Procedure> cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.id) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.id);
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.id)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + "; object #2 =" + o2);
    }
}

