/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.ArrayList;
import java.util.Iterator;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryIdentityHashSet;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.simantics.db.impl.query.TripleIntProcedure;

public abstract class CacheEntryBase
extends CacheEntry {
    public int ageAndLevel = 327680;
    private static Object NO_RESULT = new Object();
    protected static Object INVALID_RESULT = new Object();
    protected static Object FRESH = new Object(){

        public String toString() {
            return "CREATED";
        }
    };
    protected static Object READY = new Object(){

        public String toString() {
            return "READY";
        }
    };
    protected static Object PENDING = new Object(){

        public String toString() {
            return "PENDING";
        }
    };
    protected static Object DISCARDED = new Object(){

        public String toString() {
            return "DISCARDED";
        }
    };
    protected static Object REFUTED = new Object(){

        public String toString() {
            return "REFUTED";
        }
    };
    protected static Object EXCEPTED = new Object(){

        public String toString() {
            return "EXCEPTED";
        }
    };
    public Object statusOrException = FRESH;
    private CacheEntry p1 = null;
    private Object p2OrParents = null;
    private int hash = 0;
    private Object result = NO_RESULT;
    static int hit1 = 0;
    static int hit2 = 0;
    static int hit3 = 0;
    static int miss = 0;

    public final int hashCode() {
        if (this.hash == 0) {
            this.hash = this.makeHash();
        }
        return this.hash;
    }

    abstract int makeHash();

    @Override
    public final boolean isFresh() {
        return FRESH == this.statusOrException;
    }

    @Override
    public void setReady() {
        this.statusOrException = READY;
    }

    @Override
    @Deprecated
    public final boolean isReady() {
        return READY == this.statusOrException || EXCEPTED == this.statusOrException;
    }

    @Override
    public void discard() {
        this.statusOrException = DISCARDED;
    }

    @Override
    public final boolean isDiscarded() {
        return DISCARDED == this.statusOrException;
    }

    @Override
    public final void refute() {
        this.statusOrException = REFUTED;
    }

    @Override
    public final boolean isRefuted() {
        return REFUTED == this.statusOrException;
    }

    @Override
    public final void except(Throwable t) {
        this.statusOrException = EXCEPTED;
        this.result = t;
    }

    public final void checkAndThrow() throws DatabaseException {
        if (this.isExcepted()) {
            Throwable throwable = (Throwable)this.result;
            if (throwable instanceof DatabaseException) {
                throw (DatabaseException)throwable;
            }
            throw new DatabaseException(throwable);
        }
    }

    @Override
    public final boolean isExcepted() {
        return EXCEPTED == this.statusOrException;
    }

    @Override
    public final void setPending() {
        this.statusOrException = PENDING;
    }

    @Override
    public final boolean isPending() {
        return PENDING == this.statusOrException;
    }

    public final boolean assertPending() {
        boolean result = this.isPending();
        if (!result) {
            System.err.println("Assertion failed, expected pending, got " + this.statusOrException);
        }
        return result;
    }

    public final boolean assertNotPending() {
        boolean result;
        boolean bl = result = !this.isPending();
        if (!result) {
            new Exception(this + ": Assertion failed, expected not pending, got " + this.statusOrException).printStackTrace();
        }
        return result;
    }

    public final boolean assertNotDiscarded() {
        boolean result;
        boolean bl = result = !this.isDiscarded();
        if (!result) {
            new Exception(this + ": Assertion failed, expected not discarded, got " + this.statusOrException).printStackTrace();
        }
        return result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public final <T> T getResult() {
        assert (this.statusOrException != DISCARDED);
        return (T)this.result;
    }

    @Override
    public void clearResult(QuerySupport support) {
        this.setResult(NO_RESULT);
    }

    @Override
    public final void addParent(CacheEntry entry) {
        assert (entry != null);
        if (this.p1 == entry) {
            ++hit1;
            return;
        }
        if (this.p2OrParents == entry) {
            ++hit2;
            return;
        }
        if (this.p1 == null) {
            this.p1 = entry;
            ++miss;
        } else if (this.p2OrParents == null) {
            this.p2OrParents = entry;
            ++miss;
        } else if (this.p2OrParents.getClass() == QueryIdentityHashSet.class) {
            if (((QueryIdentityHashSet)this.p2OrParents).add(entry)) {
                ++miss;
            } else {
                ++hit3;
            }
        } else {
            CacheEntry tmp = (CacheEntry)this.p2OrParents;
            this.p2OrParents = new QueryIdentityHashSet(2);
            ((QueryIdentityHashSet)this.p2OrParents).add(tmp);
            ((QueryIdentityHashSet)this.p2OrParents).add(entry);
            ++miss;
        }
    }

    @Override
    void pruneParents() {
        if (this.p2OrParents instanceof QueryIdentityHashSet) {
            QueryIdentityHashSet set = (QueryIdentityHashSet)this.p2OrParents;
            set.removeDiscarded();
        }
    }

    @Override
    public final void removeParent(CacheEntry entry) {
        if (this.p1 == null) {
            if (this.p2OrParents != null) {
                throw new Error("CacheEntryBase.removeParent: corrupted parents (p1 == null, while p2OrParents != null).");
            }
            throw new Error("CacheEntryBase.removeParent: no parents.");
        }
        if (this.p1 == entry) {
            if (this.p2OrParents == null) {
                this.p1 = null;
            } else if (this.p2OrParents instanceof QueryIdentityHashSet) {
                QueryIdentityHashSet set = (QueryIdentityHashSet)this.p2OrParents;
                int size = set.size();
                if (size == 0) {
                    this.p1 = null;
                    this.p2OrParents = null;
                } else if (size == 1) {
                    CacheEntry next;
                    this.p1 = next = set.iterator().next();
                    set = null;
                } else if (set.size() == 2) {
                    Iterator<CacheEntry> iterator = set.iterator();
                    this.p1 = iterator.next();
                    this.p2OrParents = iterator.next();
                } else {
                    this.p1 = set.iterator().next();
                    set.remove(this.p1);
                }
            } else {
                this.p1 = (CacheEntry)this.p2OrParents;
                this.p2OrParents = null;
            }
        } else if (this.p2OrParents.getClass() == QueryIdentityHashSet.class) {
            QueryIdentityHashSet set = (QueryIdentityHashSet)this.p2OrParents;
            boolean success = set.remove(entry);
            if (!success) {
                throw new Error("CacheEntryBase.removeParent: parent was not found.");
            }
            assert (set.size() >= 1);
            if (set.size() == 1) {
                this.p2OrParents = set.iterator().next();
            }
        } else if (this.p2OrParents == entry) {
            this.p2OrParents = null;
        } else {
            throw new Error("CacheEntryBase.removeParent: had 2 parents but neither was removed.");
        }
    }

    @Override
    public final boolean hasParents() {
        assert (this.statusOrException != DISCARDED);
        return this.p1 != null;
    }

    @Override
    public final Iterable<CacheEntry> getParents(QueryProcessor processor) {
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
        if (this.p1 != null) {
            result.add(this.p1);
        }
        if (this.p2OrParents != null) {
            if (this.p2OrParents instanceof QueryIdentityHashSet) {
                for (CacheEntry entry : (QueryIdentityHashSet)this.p2OrParents) {
                    result.add(entry);
                }
            } else {
                result.add((CacheEntry)this.p2OrParents);
            }
        }
        this.fillImpliedParents(processor, result);
        return result;
    }

    @Override
    CacheEntry getFirstParent(QueryProcessor processor) {
        return this.p1;
    }

    @Override
    boolean moreThanOneParent(QueryProcessor processor) {
        return this.p2OrParents != null;
    }

    @Override
    int parentCount(QueryProcessor processor) {
        if (this.p2OrParents != null) {
            if (this.p2OrParents instanceof QueryIdentityHashSet) {
                return ((QueryIdentityHashSet)this.p2OrParents).size() + 1;
            }
            return 2;
        }
        return this.p1 != null ? 1 : 0;
    }

    protected void fillImpliedParents(QueryProcessor processor, ArrayList<CacheEntry> result) {
    }

    protected String internalError() {
        return String.valueOf(this.toString()) + " " + this.statusOrException + " " + this.result;
    }

    protected boolean handleException(ReadGraphImpl graph, IntProcedure procedure) {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    protected boolean handleException(ReadGraphImpl graph, TripleIntProcedure procedure) {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    protected <T> boolean handleException(ReadGraphImpl graph, InternalProcedure<T> procedure) {
        if (this.isExcepted()) {
            procedure.exception(graph, (Throwable)this.getResult());
            return true;
        }
        return false;
    }

    @Override
    boolean isImmutable(ReadGraphImpl graph) throws DatabaseException {
        return false;
    }

    @Override
    boolean shouldBeCollected() {
        return this.getAge() > 1;
    }

    @Override
    void incAge() {
        ++this.ageAndLevel;
    }

    @Override
    int getAge() {
        return this.ageAndLevel & 0xFFFF;
    }

    @Override
    int getLevel() {
        return this.ageAndLevel >> 16 & 0xFFFF;
    }

    @Override
    int setLevel(int level) {
        this.ageAndLevel = (this.ageAndLevel & 0xFFFF) + (level << 16);
        return level;
    }
}

