/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;

public abstract class BinaryQuery<Procedure>
extends CacheEntryBase
implements Query {
    public final long id;

    public BinaryQuery(long r1, long r2) {
        assert (r1 != 0L);
        assert (r2 != 0L);
        this.id = BinaryQuery.id(r1, r2);
        assert (this.id != 0L);
    }

    @Override
    int makeHash() {
        return this.r1() ^ this.r2();
    }

    public final int r1() {
        return (int)(this.id >>> 32);
    }

    public final int r2() {
        return (int)this.id;
    }

    protected static final long id(long r1, long r2) {
        long result = r1 << 32 | r2 & 0xFFFFFFFFL;
        return result;
    }

    @Override
    public int type() {
        return 0;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BinaryQuery other = (BinaryQuery)object;
        return this.id == other.id;
    }

    @Override
    public Object getOriginalRequest() {
        throw new AssertionError((Object)"This should never be called.");
    }

    @Override
    public final Query getQuery() {
        return this;
    }

    @Override
    public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
        this.recompute(graph, (QueryProcessor)provider);
    }

    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
        this.performFromCache(graph, (QueryProcessor)provider, procedure);
    }

    public abstract void recompute(ReadGraphImpl var1, QueryProcessor var2);

    public abstract void computeForEach(ReadGraphImpl var1, QueryProcessor var2, Procedure var3, boolean var4);

    public abstract void performFromCache(ReadGraphImpl var1, QueryProcessor var2, Procedure var3);

    public abstract void putEntry(QueryProcessor var1);

    @Override
    public abstract void removeEntry(QueryProcessor var1);

    public abstract BinaryQuery<Procedure> getEntry(QueryProcessor var1);
}

