/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.IntProcedureAdapter;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.CollectionUnaryQuery;
import org.simantics.db.impl.query.DirectObjects;
import org.simantics.db.impl.query.IntArray;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.UnaryQuery;
import org.simantics.db.procedure.ListenerBase;

public final class AssertedPredicates
extends CollectionUnaryQuery<IntProcedure> {
    public AssertedPredicates(int r) {
        super(r);
    }

    public static AssertedPredicates newInstance(int r) {
        return new AssertedPredicates(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void runner(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        AssertedPredicates entry = (AssertedPredicates)provider.assertedPredicatesMap.get(r);
        if (entry == null) {
            entry = new AssertedPredicates(r);
            entry.setPending();
            entry.clearResult(provider.querySupport);
            entry.putEntry(provider);
            provider.performForEach(graph, entry, parent, listener, procedure);
        } else {
            if (!entry.isReady()) {
                AssertedPredicates assertedPredicates = entry;
                synchronized (assertedPredicates) {
                    if (!entry.isReady()) {
                        throw new IllegalStateException();
                    }
                }
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
    }

    public static final void queryEach(ReadGraphImpl graph, int r, QueryProcessor provider, CacheEntry parent, ListenerBase listener, IntProcedure procedure) {
        AssertedPredicates entry;
        if (parent == null && listener == null && (entry = (AssertedPredicates)provider.assertedPredicatesMap.get(r)) != null && entry.isReady()) {
            entry.performFromCache(graph, provider, procedure);
            return;
        }
        AssertedPredicates.runner(graph, r, provider, parent, listener, procedure);
    }

    @Override
    public UnaryQuery<IntProcedure> getEntry(QueryProcessor provider) {
        return provider.assertedPredicatesMap.get(this.id);
    }

    @Override
    public void putEntry(QueryProcessor provider) {
        provider.assertedPredicatesMap.put(this.id, this);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.assertedPredicatesMap.remove(this.id);
    }

    void computeInheritedAssertions(ReadGraphImpl graph, int type, final QueryProcessor queryProvider, final IntProcedure proc, boolean store) {
        DirectObjects.queryEach(graph, type, queryProvider.getInherits(), queryProvider, this, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                AssertedPredicates.this.finish(graph, queryProvider);
                proc.finished(graph);
            }

            @Override
            public void execute(ReadGraphImpl graph, int inh) {
                this.inc();
                AssertedPredicates.queryEach(graph, inh, queryProvider, AssertedPredicates.this, null, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int ass) {
                        AssertedPredicates.this.addOrSet(ass);
                        proc.execute(graph, ass);
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        proc.exception(graph, t);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        });
    }

    @Override
    public Object computeForEach(ReadGraphImpl graph, final QueryProcessor queryProvider, final IntProcedure proc, final boolean store) {
        DirectObjects.queryEach(graph, this.id, queryProvider.getAsserts(), queryProvider, this, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) {
                AssertedPredicates.this.computeInheritedAssertions(graph, AssertedPredicates.this.id, queryProvider, proc, store);
            }

            @Override
            public void execute(ReadGraphImpl graph, int ass) {
                this.inc();
                DirectObjects.queryEach(graph, ass, queryProvider.getHasPredicate(), queryProvider, AssertedPredicates.this, null, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int pred) {
                        AssertedPredicates.this.addOrSet(pred);
                        proc.execute(graph, pred);
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) {
                        proc.exception(graph, t);
                    }
                });
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                this.dec(graph);
            }
        });
        return this.getResult();
    }

    public String toString() {
        return "AssertedPredicates[" + this.id + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finish(ReadGraphImpl graph, QueryProcessor provider) {
        assert (!this.isReady());
        AssertedPredicates assertedPredicates = this;
        synchronized (assertedPredicates) {
            this.setReady();
        }
    }

    private synchronized void addOrSet(int add) {
        assert (this.isPending());
        IntArray value = (IntArray)this.getResult();
        value.add(add);
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, IntProcedure procedure) {
        assert (this.isReady());
        if (this.handleException(graph, procedure)) {
            return EXCEPTED;
        }
        IntArray value = (IntArray)this.getResult();
        if (value.data == null) {
            if (value.sizeOrData != -1) {
                procedure.execute(graph, value.sizeOrData);
            }
        } else {
            int i = 0;
            while (i < value.sizeOrData) {
                procedure.execute(graph, value.data[i]);
                ++i;
            }
        }
        procedure.finished(graph);
        return value;
    }

    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        final Semaphore s = new Semaphore(0);
        this.computeForEach(graph, provider, new IntProcedureAdapter(){

            @Override
            public void finished(ReadGraphImpl graph) {
                s.release();
            }

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
                s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }
        }, true);
        while (!s.tryAcquire()) {
            provider.resume(graph);
        }
    }
}

