/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.utils.FileUtils;

public class WriteLogger {
    public static File logFile;
    public static RandomAccessFile raf;
    public static boolean enable;
    public static TIntHashSet created;
    private static VirtualGraph vg;

    static {
        enable = false;
        vg = null;
    }

    private static String resourceLog(ReadGraph graph, Resource resource) throws DatabaseException {
        if (!enable) {
            return null;
        }
        if (resource == null) {
            return "N";
        }
        ResourceImpl impl = (ResourceImpl)resource;
        int id = impl.id;
        if (created.contains(id)) {
            return "I" + impl.id;
        }
        String uri = graph.getPossibleURI(resource);
        if (uri != null) {
            return "U" + uri;
        }
        return "N";
    }

    private static String virtualGraphLog(ReadGraph graph) {
        WriteGraphImpl impl = (WriteGraphImpl)graph;
        VirtualGraph vg = impl.getProvider();
        if (vg == null) {
            return "N";
        }
        if (VirtualGraph.Persistency.MEMORY == vg.getPersistency()) {
            return "M" + vg.getIdentifier();
        }
        return "W" + vg.getIdentifier();
    }

    private static void logLine(String line) {
        if (!enable) {
            return;
        }
        try {
            byte[] data = line.getBytes();
            raf.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void logClaim(ReadGraph graph, Resource subject, Resource predicate, Resource inverse, Resource object) throws DatabaseException {
        WriteLogger.logLine("C\t" + WriteLogger.virtualGraphLog(graph) + "\t" + WriteLogger.resourceLog(graph, subject) + "\t" + WriteLogger.resourceLog(graph, predicate) + "\t" + WriteLogger.resourceLog(graph, inverse) + "\t" + WriteLogger.resourceLog(graph, object) + "\n");
    }

    public static void logDeny(ReadGraph graph, Resource subject, Resource predicate, Resource inverse, Resource object) throws DatabaseException {
        WriteLogger.logLine("D\t" + WriteLogger.virtualGraphLog(graph) + "\t" + WriteLogger.resourceLog(graph, subject) + "\t" + WriteLogger.resourceLog(graph, predicate) + "\t" + WriteLogger.resourceLog(graph, inverse) + "\t" + WriteLogger.resourceLog(graph, object) + "\n");
    }

    public static void logNewResource(ReadGraph graph, Resource subject) throws DatabaseException {
        if (!enable) {
            return;
        }
        ResourceImpl impl = (ResourceImpl)subject;
        created.add(impl.id);
        WriteLogger.logLine("R\t" + WriteLogger.virtualGraphLog(graph) + "\t" + WriteLogger.resourceLog(graph, subject) + "\n");
    }

    public static void logValue(ReadGraph graph, Resource subject, byte[] value) throws DatabaseException {
        if (!enable) {
            return;
        }
        try {
            WriteLogger.logLine("V\t" + WriteLogger.virtualGraphLog(graph) + "\t" + WriteLogger.resourceLog(graph, subject) + "\t" + Bindings.BYTE_ARRAY.toString((Object)value) + "\n");
        }
        catch (BindingException e) {
            e.printStackTrace();
        }
    }

    private static Resource readResource(WriteGraph graph, String id, HashMap<String, Resource> ids) throws DatabaseException {
        if (id.startsWith("I")) {
            Resource result = ids.get(id);
            if (result == null) {
                System.err.println("undeclared id='" + id + "'");
            }
            return result;
        }
        if (id.startsWith("U")) {
            return graph.getPossibleResource(id.substring(1));
        }
        return null;
    }

    private static VirtualGraph getVirtualGraph(WriteGraphImpl graph, String id) {
        if ("N".equals(id)) {
            return null;
        }
        VirtualGraphSupport vgs = graph.getService(VirtualGraphSupport.class);
        if (id.startsWith("M")) {
            return vgs.getMemoryPersistent(id.substring(1));
        }
        return vgs.getWorkspacePersistent(id.substring(1));
    }

    private static WriteGraphImpl applyVirtualGraph(WriteGraphImpl graph, String id) {
        VirtualGraph target = WriteLogger.getVirtualGraph(graph, id);
        if (target != vg) {
            vg = target;
            return graph.newSync(target);
        }
        return graph;
    }

    public static void read(WriteGraph _graph) throws Exception {
        vg = null;
        WriteGraphImpl graph = (WriteGraphImpl)_graph;
        String data = FileUtils.getContents((InputStream)new FileInputStream(logFile)).replace("\r", "");
        HashMap<String, Resource> ids = new HashMap<String, Resource>();
        String[] stringArray = data.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource object;
            Resource inverse;
            Resource predicate;
            Resource subject;
            String line = stringArray[n2];
            String[] parts = line.split("\t");
            if ("C".equals(parts[0])) {
                graph = WriteLogger.applyVirtualGraph(graph, parts[1]);
                subject = WriteLogger.readResource(graph, parts[2], ids);
                predicate = WriteLogger.readResource(graph, parts[3], ids);
                inverse = WriteLogger.readResource(graph, parts[4], ids);
                object = WriteLogger.readResource(graph, parts[5], ids);
                if (subject == null || predicate == null || object == null) {
                    System.err.println("skipped statement");
                } else {
                    graph.claim(subject, predicate, inverse, object);
                }
            } else if ("D".equals(parts[0])) {
                graph = WriteLogger.applyVirtualGraph(graph, parts[1]);
                subject = WriteLogger.readResource(graph, parts[2], ids);
                predicate = WriteLogger.readResource(graph, parts[3], ids);
                inverse = WriteLogger.readResource(graph, parts[4], ids);
                object = WriteLogger.readResource(graph, parts[5], ids);
                if (subject == null || predicate == null || object == null) {
                    System.err.println("skipped statement");
                } else {
                    graph.deny(subject, predicate, inverse, object);
                }
            } else if ("R".equals(parts[0])) {
                graph = WriteLogger.applyVirtualGraph(graph, parts[1]);
                Resource resource = graph.newResource();
                ids.put(parts[2], resource);
            } else if ("V".equals(parts[0]) && (subject = WriteLogger.readResource(graph = WriteLogger.applyVirtualGraph(graph, parts[1]), parts[2], ids)) != null) {
                byte[] value = (byte[])Bindings.BYTE_ARRAY.parseValue(parts[3], new DataValueRepository());
                TransferableGraphSupport tgSupport = graph.getService(TransferableGraphSupport.class);
                tgSupport.setValue((WriteOnlyGraph)graph, subject, vg, value);
            }
            ++n2;
        }
    }
}

