/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.impl.BindingPrintContext;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.ClusterSetExistException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.WriteResult;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.ByteReader;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.MapList;

public class DelayedWriteGraph
extends ReadGraphImpl
implements WriteGraph,
ByteReader {
    private static final boolean DEBUG = false;
    public static int BUFFER = 65536;
    private static final Haxx haxx = new Haxx();
    private final int TERM = 0;
    private final int CLAIM = 1;
    private final int CLAIM_NOINVERSE = 2;
    private final int CLAIM_VALUE_B = 4;
    private final int DENY = 5;
    private final int DENY_VALUE = 6;
    public State writeState;
    Layer0 b;
    Session session;
    private FileChannel channel;
    byte[] bytes = new byte[BUFFER];
    byte[] buffer = new byte[BUFFER];
    ByteBuffer bb = ByteBuffer.wrap(this.bytes);
    int byteIndex = 0;

    public static Resource convertDelayedResource(Resource r) {
        if (r instanceof InternalResource) {
            InternalResource ri = (InternalResource)r;
            return ri.resource;
        }
        return r;
    }

    private int getId(Resource resource) {
        if (resource instanceof InternalResource) {
            return ((InternalResource)resource).id;
        }
        ResourceImpl r = (ResourceImpl)resource;
        int id = this.writeState.externalToId.get(r.id);
        if (id != 0) {
            return id;
        }
        id = this.writeState.idToResource.size();
        this.writeState.idToResource.add(resource);
        this.writeState.externalToId.put(r.id, id);
        return id;
    }

    private Resource getResource(int id) {
        return this.writeState.idToResource.get(id);
    }

    private int getBindingId(Binding binding) {
        if (this.writeState.bindingToId.contains((Object)binding)) {
            return this.writeState.bindingToId.get((Object)binding);
        }
        int id = this.writeState.idToBinding.size();
        this.writeState.idToBinding.add(binding);
        this.writeState.bindingToId.put((Object)binding, id);
        return id;
    }

    public DelayedWriteGraph(ReadGraph g) throws IOException {
        super((ReadGraphImpl)g);
        this.writeState = new State();
        this.session = g.getSession();
        this.b = Layer0.getInstance((ReadGraph)g);
        this.writeState.defaultCluster = this.newCluster();
    }

    public DelayedWriteGraph(ReadGraph g, State state) {
        super((ReadGraphImpl)g);
        this.session = g.getSession();
        this.b = Layer0.getInstance((ReadGraph)g);
        this.writeState = state;
    }

    public DelayedWriteGraph newSync() {
        return new DelayedWriteGraph(this, this.writeState);
    }

    public void claim(Resource subject, Resource predicate, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        Resource inverse = this.getPossibleInverse(predicate);
        this.claim(subject, predicate, inverse, object);
    }

    public void claimValue(Resource resource, Resource predicate, Object value) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Binding b;
        try {
            b = Bindings.getBinding(value.getClass());
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
        this.claimValue(resource, predicate, value, b);
    }

    public void addValue(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Resource valueResource = this.newResource();
        this.claimValue(valueResource, value, binding);
        this.claim(valueResource, this.b.InstanceOf, null, type);
        this.claim(resource, predicate, inverse, valueResource);
    }

    public void addLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Resource valueResource = this.newResource();
        this.claimValue(valueResource, value, binding);
        this.claim(valueResource, this.b.InstanceOf, null, type);
        this.claim(resource, predicate, inverse, valueResource);
    }

    public void addLiteral(Resource resource, Resource predicate, Resource inverse, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Resource type = this.getType(value);
        if (type == null) {
            Resource literal = this.newResource();
            type = this.b.Literal;
            Resource dataType = this.newResource();
            this.claim(dataType, this.b.InstanceOf, null, this.b.Literal);
            this.claimValue(dataType, binding.type(), DATA_TYPE_BINDING_INTERNAL);
            this.claim(literal, this.b.HasDataType, null, dataType);
            this.claim(literal, this.b.InstanceOf, null, type);
            this.claimValue(literal, value, binding);
            this.claim(resource, predicate, inverse, literal);
        } else {
            this.addLiteral(resource, predicate, inverse, type, value, binding);
        }
    }

    public void claimValue(Resource resource, Resource predicate, Object value, Binding binding) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Statement valueStatement = null;
        if (!(resource instanceof InternalResource)) {
            valueStatement = this.getPossibleStatement(resource, predicate);
        }
        if (valueStatement != null && resource.equals(valueStatement.getSubject())) {
            this.claimValue(valueStatement.getObject(), value, binding);
        } else {
            Resource type = this.getType(value);
            Resource literal = this.newResource();
            if (type == null) {
                type = this.b.Literal;
                Resource dataType = this.newResource();
                this.claim(dataType, this.b.InstanceOf, null, this.b.Literal);
                this.claimValue(dataType, binding.type(), DATA_TYPE_BINDING_INTERNAL);
                this.claim(literal, this.b.HasDataType, dataType);
            }
            this.claim(literal, this.b.InstanceOf, null, type);
            this.claimValue(literal, value, binding);
            this.claim(resource, predicate, literal);
        }
    }

    public void claimValue(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Statement valueStatement;
        Statement statement = valueStatement = resource instanceof InternalResource ? null : this.getPossibleStatement(resource, predicate);
        if (valueStatement != null && resource.equals(valueStatement.getSubject())) {
            this.claimValue(valueStatement.getObject(), value, binding);
        } else {
            Resource valueResource = this.newResource();
            this.claim(valueResource, this.b.InstanceOf, null, type);
            this.claim(resource, predicate, inverse, valueResource);
            this.claimValue(valueResource, value, binding);
        }
    }

    public <T extends Accessor> T newLiteral(Resource resource, Resource predicate, Datatype datatype, Object initialValue) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public RandomAccessBinary createRandomAccessBinary(Resource resource, Resource predicate, Datatype datatype, Object initialValue) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RandomAccessBinary createRandomAccessBinary(Resource resource, Datatype datatype, Object initialValue) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void claimLiteral(Resource resource, Resource predicate, Object value) throws ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding b = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, value, b);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BindingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        this.claimValue(resource, predicate, value, binding);
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding b = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, inverse, type, value, b);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BindingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        this.claimValue(resource, predicate, inverse, type, value, binding);
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource type, Object value) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding b = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, type, value, b);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
        catch (BindingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Resource inverse = this.getSingleObject(predicate, this.b.InverseOf);
            this.claimLiteral(resource, predicate, inverse, type, value, binding);
        }
        catch (NoSingleResultException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void deny(Resource subject) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public void deny(Resource subject, Resource predicate) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public void deny(Resource subject, Resource predicate, Resource object) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public void denyStatement(Resource subject, Resource predicate, Resource object) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public void deny(Statement statement) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public void denyValue(Resource resource, Resource predicate) throws ManyObjectsForFunctionalRelationException, ServiceException {
        throw new UnsupportedOperationException();
    }

    public Resource newResource() throws ServiceException {
        if (this.writeState.defaultClusterSet != null) {
            return this.newResource(this.writeState.defaultClusterSet);
        }
        return this.newResource(this.writeState.defaultCluster);
    }

    public Resource newResource(long clusterId) throws ServiceException {
        int id = this.writeState.idToResource.size();
        InternalResource ret = new InternalResource(id, clusterId);
        this.writeState.idToResource.add(ret);
        return ret;
    }

    public Resource newResource(Resource clusterSet) throws ServiceException {
        WriteSupport ws;
        if (clusterSet instanceof InternalResource ? !this.writeState.clusterSets.contains(clusterSet) : !(ws = (WriteSupport)this.session.getService(WriteSupport.class)).hasClusterSet(null, clusterSet) && !this.writeState.clusterSetsForExistingResources.contains(clusterSet)) {
            throw new ClusterSetExistException("Cluster set does not exist. Resource=" + clusterSet);
        }
        int id = this.writeState.idToResource.size();
        InternalResource ret = new InternalResource(id, clusterSet);
        this.writeState.idToResource.add(ret);
        return ret;
    }

    public void newClusterSet(Resource clusterSet) throws ServiceException {
        boolean existingResource;
        boolean bl = existingResource = !(clusterSet instanceof InternalResource);
        if (existingResource) {
            WriteSupport ws = (WriteSupport)this.session.getService(WriteSupport.class);
            if (ws.hasClusterSet(null, clusterSet)) {
                throw new ClusterSetExistException("Cluster set exist already. Resource=" + clusterSet);
            }
            this.writeState.clusterSetsForExistingResources.add(clusterSet);
        } else if (!this.writeState.clusterSets.add(clusterSet)) {
            throw new ClusterSetExistException("Cluster set exist already. Resource=" + clusterSet);
        }
    }

    public Resource setClusterSet4NewResource(Resource clusterSet) throws ServiceException {
        Resource existing = this.writeState.defaultClusterSet;
        this.writeState.defaultClusterSet = clusterSet;
        return existing;
    }

    public void claim(Resource subject, Resource predicate, Resource inverse, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        try {
            if (!(inverse == null || subject.equals(object) && inverse.equals(predicate))) {
                this.writeByte(1);
                this.writeInt(this.getId(subject));
                this.writeInt(this.getId(predicate));
                this.writeInt(this.getId(inverse));
                this.writeInt(this.getId(object));
            } else {
                this.writeByte(2);
                this.writeInt(this.getId(subject));
                this.writeInt(this.getId(predicate));
                this.writeInt(this.getId(object));
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void deny(Resource subject, Resource predicate, Resource inverse, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        try {
            this.writeByte(5);
            this.writeInt(this.getId(subject));
            this.writeInt(this.getId(predicate));
            if (inverse != null) {
                this.writeInt(this.getId(inverse));
            } else {
                this.writeInt(0);
            }
            this.writeInt(this.getId(object));
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void deny(Resource subject, Resource predicate, Resource inverse, Resource object, VirtualGraph graph) throws ServiceException {
        throw new UnsupportedOperationException();
    }

    public void claimValue(Resource resource, Object value) throws ServiceException {
        try {
            Binding binding = Bindings.getBinding(value.getClass());
            this.claimValue(resource, value, binding);
        }
        catch (BindingConstructionException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void claimValue(Resource resource, Object value, Binding binding) throws ServiceException {
        try {
            this.writeByte(4);
            this.writeInt(this.getId(resource));
            Serializer serializer = Bindings.getSerializerUnchecked((Binding)binding);
            int size = serializer.getSize(value);
            this.writeInt(size);
            serializer.serialize(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    DelayedWriteGraph.this.writeByte(b);
                }
            }, value);
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void denyValue(Resource resource) throws ServiceException {
        this.writeByte(6);
        this.writeInt(this.getId(resource));
    }

    public void flushCluster() throws ServiceException {
        this.writeState.defaultCluster = this.newCluster();
    }

    public void flushCluster(Resource r) throws ServiceException {
        throw new ServiceException("Operation flushCluster(" + r + " not implemented.");
    }

    private void writeReset(int size) {
        this.byteIndex = 0;
        this.bb.position(0);
        this.bb.limit(size);
        try {
            if (this.writeState.tempFile == null) {
                Bundle b = Platform.getBundle((String)"org.simantics.db.impl");
                IPath state = Platform.getStateLocation((Bundle)b);
                File base = state.append("delayed").toFile();
                base.mkdirs();
                this.writeState.tempFile = new File(base, UUID.randomUUID().toString());
                this.writeState.out = new FileOutputStream(this.writeState.tempFile);
                this.channel = this.writeState.out.getChannel();
            }
            int got = 0;
            while (got < size) {
                int n = this.channel.write(this.bb);
                if (n <= 0) {
                    new Exception().printStackTrace();
                    return;
                }
                got += n;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void reset() {
        this.byteIndex = 0;
        try {
            this.bb.clear();
            int got = 0;
            while (got < BUFFER) {
                int n = this.channel.read(this.bb);
                if (n <= 0) {
                    return;
                }
                got += n;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeInt(int i) {
        if (this.byteIndex < BUFFER - 4) {
            this.bytes[this.byteIndex++] = (byte)(i & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 8 & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 16 & 0xFF);
            this.bytes[this.byteIndex++] = (byte)(i >>> 24 & 0xFF);
            if (this.byteIndex == BUFFER) {
                this.writeReset(BUFFER);
            }
        } else {
            int has = BUFFER - this.byteIndex;
            if (has == 0) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(i & 0xFF);
            if (has == 1) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 8 & 0xFF);
            if (has == 2) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 16 & 0xFF);
            if (has == 3) {
                this.writeReset(BUFFER);
            }
            this.bytes[this.byteIndex++] = (byte)(i >>> 24 & 0xFF);
            if (has == 4) {
                this.writeReset(BUFFER);
            }
        }
    }

    private int readInt() {
        if (this.byteIndex < BUFFER - 4) {
            int result = this.bytes[this.byteIndex++] & 0xFF | (this.bytes[this.byteIndex++] & 0xFF) << 8 | (this.bytes[this.byteIndex++] & 0xFF) << 16 | (this.bytes[this.byteIndex++] & 0xFF) << 24;
            return result;
        }
        int has = BUFFER - this.byteIndex;
        int result = 0;
        if (has == 0) {
            this.reset();
        }
        result = this.bytes[this.byteIndex++] & 0xFF;
        if (has == 1) {
            this.reset();
        }
        result |= (this.bytes[this.byteIndex++] & 0xFF) << 8;
        if (has == 2) {
            this.reset();
        }
        result |= (this.bytes[this.byteIndex++] & 0xFF) << 16;
        if (has == 3) {
            this.reset();
        }
        result |= (this.bytes[this.byteIndex++] & 0xFF) << 24;
        if (has == 4) {
            this.reset();
        }
        return result;
    }

    private byte readByte() {
        byte result = this.bytes[this.byteIndex++];
        if (this.byteIndex == BUFFER) {
            this.reset();
        }
        return result;
    }

    private void writeByte(int b) {
        this.bytes[this.byteIndex++] = (byte)b;
        if (this.byteIndex == BUFFER) {
            this.writeReset(BUFFER);
        }
    }

    private void writeBytes(byte[] data) {
        int has = BUFFER - this.byteIndex;
        int amount = data.length;
        if (has > amount) {
            System.arraycopy(data, 0, this.bytes, this.byteIndex, amount);
            this.byteIndex += amount;
        } else {
            System.arraycopy(data, 0, this.bytes, this.byteIndex, has);
            this.writeReset(BUFFER);
            ByteBuffer bb2 = ByteBuffer.wrap(data);
            bb2.position(has);
            try {
                this.channel.write(bb2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public byte[] readBytes(int amount) {
        return this.readBytes(this.buffer, amount);
    }

    public byte[] readBytes(byte[] result, int amount) {
        int has;
        if (result == null) {
            result = new byte[amount];
        }
        if ((has = BUFFER - this.byteIndex) > amount) {
            System.arraycopy(this.bytes, this.byteIndex, result, 0, amount);
            this.byteIndex += amount;
        } else {
            System.arraycopy(this.bytes, this.byteIndex, result, 0, has);
            ByteBuffer bb2 = ByteBuffer.wrap(result);
            bb2.position(has);
            int got = has;
            while (got < amount) {
                try {
                    if ((got += this.channel.read(bb2)) != -1) continue;
                    new Exception().printStackTrace();
                    return result;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.reset();
        }
        return result;
    }

    public void commit(WriteOnlyGraph w) throws ServiceException {
        InternalResource ir2;
        this.writeState.bindingToId = null;
        this.writeState.externalToId = null;
        try {
            this.writeByte(0);
            if (this.byteIndex > 0) {
                this.writeReset(this.byteIndex);
            }
            this.channel.force(false);
            this.writeState.out.close();
            FileInputStream fs = new FileInputStream(this.writeState.tempFile);
            this.channel = fs.getChannel();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        TransferableGraphSupport tgs = (TransferableGraphSupport)w.getService(TransferableGraphSupport.class);
        MapList clusterAssignment = new MapList();
        for (Resource r : this.writeState.idToResource) {
            if (!(r instanceof InternalResource)) continue;
            ir2 = (InternalResource)r;
            if (ir2.clusterId < 0L) {
                clusterAssignment.add((Object)ir2.clusterId, (Object)ir2);
                continue;
            }
            if (ir2.clusterId <= 0L) continue;
            ir2.resource = w.newResource(ir2.clusterId);
            this.writeState.idToResource.set(ir2.id, ir2.resource);
            if (!this.writeState.clusterSets.contains(ir2)) continue;
            w.newClusterSet(ir2.resource);
        }
        for (Long clusterKey : clusterAssignment.getKeys()) {
            w.flushCluster();
            for (InternalResource ir2 : clusterAssignment.getValues((Object)clusterKey)) {
                ir2.resource = w.newResource();
                this.writeState.idToResource.set(ir2.id, ir2.resource);
                if (!this.writeState.clusterSets.contains(ir2)) continue;
                w.newClusterSet(ir2.resource);
            }
        }
        for (Resource existingResource : this.writeState.clusterSetsForExistingResources) {
            w.newClusterSet(existingResource);
        }
        for (Resource r : this.writeState.idToResource) {
            if (!(r instanceof InternalResource)) continue;
            ir2 = (InternalResource)r;
            Resource clusterSet = ir2.clusterSet;
            if (clusterSet == null) continue;
            ir2.resource = clusterSet instanceof InternalResource ? w.newResource(((InternalResource)clusterSet).resource) : w.newResource(clusterSet);
            this.writeState.idToResource.set(ir2.id, ir2.resource);
            if (!this.writeState.clusterSets.contains(ir2)) continue;
            w.newClusterSet(ir2.resource);
        }
        this.reset();
        this.bb.limit(BUFFER);
        try {
            while (true) {
                byte method = this.readByte();
                switch (method) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        this.writeState.statementCount += 2;
                        Resource subject = this.getResource(this.readInt());
                        Resource predicate = this.getResource(this.readInt());
                        Resource inverse = this.getResource(this.readInt());
                        Resource object = this.getResource(this.readInt());
                        w.claim(subject, predicate, inverse, object);
                        break;
                    }
                    case 2: {
                        ++this.writeState.statementCount;
                        Resource subject = this.getResource(this.readInt());
                        Resource predicate = this.getResource(this.readInt());
                        Resource object = this.getResource(this.readInt());
                        w.claim(subject, predicate, null, object);
                        break;
                    }
                    case 5: {
                        Resource subject = this.getResource(this.readInt());
                        Resource predicate = this.getResource(this.readInt());
                        int inv = this.readInt();
                        Resource inverse = null;
                        if (inv > 0) {
                            inverse = this.getResource(inv);
                        }
                        Resource object = this.getResource(this.readInt());
                        w.deny(subject, predicate, inverse, object, null);
                        break;
                    }
                    case 6: {
                        Resource subject = this.getResource(this.readInt());
                        w.denyValue(subject);
                        break;
                    }
                    case 4: {
                        ++this.writeState.valueCount;
                        Resource resource = this.getResource(this.readInt());
                        int len = this.readInt();
                        tgs.setValue(w, resource, null, (ByteReader)this, len);
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw (ServiceException)e;
            }
            throw new ServiceException((Throwable)e);
        }
    }

    private Resource getType(Object value) {
        Class<?> clazz = value.getClass();
        Resource dataType = clazz == Float.class ? this.b.Float : (clazz == Double.class ? this.b.Double : (clazz == Integer.class ? this.b.Integer : (clazz == String.class ? this.b.String : (clazz == Boolean.class ? this.b.Boolean : (clazz == float[].class ? this.b.FloatArray : (clazz == double[].class ? this.b.DoubleArray : (clazz == int[].class ? this.b.IntegerArray : (clazz == String[].class ? this.b.StringArray : (clazz == boolean[].class ? this.b.BooleanArray : null)))))))));
        return dataType;
    }

    public long newCluster() {
        return -1 - ++this.writeState.clusterCount;
    }

    public long getDefaultCluster() {
        return this.writeState.defaultCluster;
    }

    public void setDefaultCluster(long cluster) {
        this.writeState.defaultCluster = cluster;
    }

    @Override
    public void syncRequest(DelayedWrite request) throws DatabaseException {
        DelayedWrite syncParent = request;
        DelayedWriteGraph graph = this.newSync();
        try {
            request.perform((WriteGraph)graph);
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
    }

    @Override
    public <T> T getService(Class<T> api) {
        if (ClusteringSupport.class == api) {
            final ClusteringSupport support = (ClusteringSupport)super.getService(api);
            return (T)new ClusteringSupport(){

                public Resource getResourceByIndexAndCluster(int resourceIndex, long clusterId) throws DatabaseException, ResourceNotFoundException {
                    return support.getResourceByIndexAndCluster(resourceIndex, clusterId);
                }

                public Resource getResourceByKey(int resourceKey) throws ResourceNotFoundException {
                    return support.getResourceByKey(resourceKey);
                }

                public int getNumberOfResources(long clusterId) throws DatabaseException {
                    return support.getNumberOfResources(clusterId);
                }

                public long getCluster(Resource r) {
                    return support.getCluster(r);
                }

                public long createCluster() {
                    return DelayedWriteGraph.this.newCluster();
                }

                public boolean isClusterSet(Resource r) throws DatabaseException {
                    throw new UnsupportedOperationException();
                }

                public Resource getClusterSetOfCluster(Resource r) {
                    throw new UnsupportedOperationException();
                }

                public Resource getClusterSetOfCluster(long cluster) throws DatabaseException {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (TransferableGraphSupport.class == api) {
            return (T)new TransferableGraphSupport(){

                public void setValue(WriteOnlyGraph graph, Resource resource, VirtualGraph provider, byte[] raw) {
                    DelayedWriteGraph.this.writeByte(4);
                    DelayedWriteGraph.this.writeInt(DelayedWriteGraph.this.getId(resource));
                    DelayedWriteGraph.this.writeInt(raw.length);
                    DelayedWriteGraph.this.writeBytes(raw);
                    DelayedWriteGraph.this.writeInt(DelayedWriteGraph.this.getBindingId(haxx));
                }

                public void setValue(WriteOnlyGraph graph, Resource resource, VirtualGraph provider, ByteReader reader, int amount) throws DatabaseException {
                    DelayedWriteGraph.this.writeByte(4);
                    DelayedWriteGraph.this.writeInt(DelayedWriteGraph.this.getId(resource));
                    DelayedWriteGraph.this.writeInt(amount);
                    DelayedWriteGraph.this.writeBytes(reader.readBytes(null, amount));
                    DelayedWriteGraph.this.writeInt(DelayedWriteGraph.this.getBindingId(haxx));
                }

                public byte[] getValue(ReadGraph graph, Resource resource) {
                    throw new RuntimeException("Not supported.");
                }

                public InputStream getValueStream(ReadGraph graph, Resource resource) {
                    throw new RuntimeException("Not supported.");
                }
            };
        }
        return super.getService(api);
    }

    public <T> void addMetadata(Metadata data) throws ServiceException {
        throw new Error("Not implemented");
    }

    public <T extends Metadata> T getMetadata(Class<T> clazz) throws ServiceException {
        throw new Error("Not implemented");
    }

    public TreeMap<String, byte[]> getMetadata() {
        throw new Error("Not implemented");
    }

    @Override
    public <T> T syncRequest(WriteResult<T> request) throws DatabaseException {
        return (T)request.perform((WriteGraph)this);
    }

    public VirtualGraph getProvider() {
        return null;
    }

    public void clearUndoList(WriteTraits writeTraits) {
        WriteSupport ws = (WriteSupport)this.session.getService(WriteSupport.class);
        if (ws != null) {
            ws.clearUndoList(writeTraits);
        }
    }

    public void combineWithPrevious(WriteTraits writeTraits) {
        WriteSupport ws = (WriteSupport)this.session.getService(WriteSupport.class);
        if (ws != null) {
            ws.combineWithPrevious(writeTraits);
        }
    }

    public void markUndoPoint() {
    }

    static class ClusterSet {
        public Resource resource;
        private TIntArrayList ids = new TIntArrayList();
        private final boolean old;

        ClusterSet() {
            this.old = false;
        }

        ClusterSet(boolean old, Resource r) {
            this.old = old;
            this.resource = r;
        }

        void add(int id) {
            this.ids.add(id);
        }

        boolean isNew() {
            return !this.old;
        }
    }

    static class Haxx
    extends Binding {
        static final Serializer serializer = new Serializer(){

            public byte[] serialize(Object obj) throws SerializationException {
                return (byte[])obj;
            }

            public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
                throw new Error("Not supported.");
            }

            public void serialize(DataOutput out, Object obj) throws IOException {
                throw new Error("Not supported.");
            }

            public Object deserialize(DataInput in, List<Object> identities) throws IOException {
                throw new Error("Not supported.");
            }

            public Object deserialize(DataInput in) throws IOException {
                throw new Error("Not supported.");
            }

            public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
                throw new Error("Not supported.");
            }

            public void deserializeTo(DataInput in, Object obj) throws IOException {
                throw new Error("Not supported.");
            }

            public void skip(DataInput in, List<Object> identities) throws IOException {
                throw new Error("Not supported.");
            }

            public void skip(DataInput in) throws IOException {
                throw new Error("Not supported.");
            }

            public Integer getConstantSize() {
                throw new Error("Not supported.");
            }

            public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
                throw new Error("Not supported.");
            }

            public int getSize(Object obj) throws IOException {
                throw new Error("Not supported.");
            }

            public int getMinSize() {
                throw new Error("Not supported.");
            }
        };

        Haxx() {
        }

        public Serializer serializer() {
            return serializer;
        }

        public void accept(Binding.Visitor1 v, Object obj) {
            throw new Error("Not supported.");
        }

        public <T> T accept(Binding.Visitor<T> v) {
            throw new Error("Not supported.");
        }

        public boolean isInstance(Object obj) {
            throw new Error("Not supported.");
        }

        public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws org.simantics.databoard.binding.error.BindingException {
            throw new Error("Not supported.");
        }

        public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws org.simantics.databoard.binding.error.BindingException {
            throw new Error("Not supported.");
        }

        public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws org.simantics.databoard.binding.error.BindingException {
            throw new Error("Not supported.");
        }

        public void readFrom(Binding srcBinding, Object src, Object dst) throws org.simantics.databoard.binding.error.BindingException {
            throw new Error("Not supported.");
        }

        public Object readFromTry(Binding srcBinding, Object src, Object dst) throws org.simantics.databoard.binding.error.BindingException {
            throw new Error("Not supported.");
        }

        protected void toString(Object value, BindingPrintContext ctx) throws org.simantics.databoard.binding.error.BindingException {
            throw new Error("Not supported.");
        }

        public int getComponentCount() {
            throw new Error("Not supported.");
        }

        public Binding getComponentBinding(int index) {
            throw new Error("Not supported.");
        }

        public Binding getComponentBinding(ChildReference path) {
            throw new Error("Not supported.");
        }
    }

    private static class InternalResource
    implements Resource {
        int id;
        long clusterId = 0L;
        Resource resource = null;
        Resource clusterSet = null;

        public InternalResource(int id, long clusterId) {
            this.id = id;
            this.clusterId = clusterId;
        }

        public InternalResource(int id, Resource clusterSet) {
            this.id = id;
            this.clusterSet = clusterSet;
        }

        public long getResourceId() {
            throw new UnsupportedOperationException();
        }

        public Resource get() {
            return this;
        }

        public boolean isPersistent() {
            return false;
        }

        public int compareTo(Resource o) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public int getThreadHash() {
            return this.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof InternalResource)) {
                return false;
            }
            InternalResource other = (InternalResource)obj;
            return this.id == other.id;
        }

        public boolean equalsResource(Resource other) {
            return this.equals(other);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[did=");
            sb.append(this.id);
            sb.append("]");
            return sb.toString();
        }
    }

    public class State {
        public File tempFile;
        public FileOutputStream out;
        public ArrayList<Resource> idToResource = new ArrayList();
        public TIntIntHashMap externalToId = new TIntIntHashMap();
        public ArrayList<Binding> idToBinding = new ArrayList();
        public TObjectIntHashMap<Binding> bindingToId = new TObjectIntHashMap();
        public Set<Resource> clusterSets = new HashSet<Resource>();
        public Set<Resource> clusterSetsForExistingResources = new HashSet<Resource>();
        public int clusterCount = 0;
        public long defaultCluster;
        public Resource defaultClusterSet;
        public int statementCount = 0;
        public int valueCount = 0;
        public int fileCount = 0;
    }
}

