/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.VirtualGraphContext;
import org.simantics.db.VirtualGraphSource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.VirtualCluster;
import org.simantics.db.impl.VirtualGraphImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.impl.support.VirtualGraphServerSupport;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.datastructures.Callback;

public class TransientGraph
implements VirtualGraphImpl,
VirtualGraphContext {
    private static final boolean DEBUG = false;
    private static final int SWAP_LIMIT = 30;
    private static final VirtualCluster NO_CLUSTER = new VirtualCluster(-1);
    private final VirtualGraph.Persistency persistency;
    private final SerialisationSupport serialization;
    private final ResourceSupport resourceSupport;
    private final VirtualGraphServerSupport virtualGraphServerSupport;
    private final RequestProcessor sessionRequestProcessor;
    private final ArrayList<VirtualCluster> clusters = new ArrayList();
    private final LinkedList<VirtualCluster> memoryClusters = new LinkedList();
    private final HashSet<VirtualGraphSource> sources = new HashSet();
    final String identifier;
    final String databaseId;
    TIntObjectHashMap<TIntHashSet> NO_STATEMENTS = new TIntObjectHashMap();
    int[] EMPTY = new int[0];

    public TransientGraph(SerialisationSupport ss, VirtualGraphServerSupport vgss, ResourceSupport rs, RequestProcessor srp, String databaseId, String identifier, boolean load) {
        this.serialization = ss;
        this.virtualGraphServerSupport = vgss;
        this.sessionRequestProcessor = srp;
        this.resourceSupport = rs;
        this.identifier = identifier;
        this.databaseId = databaseId;
        VirtualGraph.Persistency persistency = this.persistency = load ? VirtualGraph.Persistency.WORKSPACE : VirtualGraph.Persistency.MEMORY;
        if (load) {
            try {
                this.load();
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private int transientClusterId(long id) throws DatabaseException {
        if ((id & 1L) == 0L) {
            return (int)id;
        }
        int rk = this.serialization.getTransientId(id);
        return ClusterTraitsBase.getClusterKeyFromResourceKey(rk) << 1 | 1;
    }

    private void load() throws DatabaseException {
        String prefix = String.valueOf(this.identifier) + "." + this.databaseId;
        String[] stringArray = this.virtualGraphServerSupport.storagePath().list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.startsWith(prefix)) {
                long clusterLong = Long.parseLong(file.substring(prefix.length() + 4));
                int clusterId = this.transientClusterId(clusterLong);
                VirtualCluster cluster = new VirtualCluster(clusterId);
                cluster.load(new File(this.virtualGraphServerSupport.storagePath(), file), this.serialization, (clusterId & 1) > 0 ? this.virtualGraphServerSupport : null);
                this.clusters.ensureCapacity(clusterId + 1);
                int i = this.clusters.size();
                while (i < clusterId + 1) {
                    this.clusters.add(null);
                    ++i;
                }
                this.clusters.set(clusterId, cluster);
                this.memoryClusters.addLast(cluster);
            }
            ++n2;
        }
    }

    public void dispose() {
        try {
            this.saveImpl(this.serialization, this.databaseId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            this.saveImpl(this.serialization, this.databaseId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveImpl(SerialisationSupport ss, String databaseId) throws IOException {
        for (VirtualCluster cluster : this.memoryClusters) {
            File file = new File(this.virtualGraphServerSupport.storagePath(), String.valueOf(this.identifier) + "." + databaseId + ".vg." + VirtualCluster.getClusterIdentifier(ss, cluster.clusterId()));
            cluster.saveImpl(file, ss);
        }
    }

    static void uncheckedClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void trimClusters() {
        for (VirtualCluster cluster : this.memoryClusters) {
            cluster.trim();
        }
    }

    public static int getVirtualClusterKey(int subject) {
        if (subject > 0) {
            int ck = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(subject);
            return ck << 1 | 1;
        }
        int ck = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(~subject);
        return ck << 1;
    }

    private VirtualCluster getOrLoad(int virtualClusterKey) {
        if (virtualClusterKey < this.clusters.size()) {
            VirtualCluster cluster = this.clusters.get(virtualClusterKey);
            if (NO_CLUSTER == cluster) {
                return null;
            }
            if (cluster != null) {
                return cluster;
            }
        }
        this.clusters.ensureCapacity(virtualClusterKey + 1);
        int i = this.clusters.size();
        while (i < virtualClusterKey + 1) {
            this.clusters.add(null);
            ++i;
        }
        long clusterIdentifier = VirtualCluster.getClusterIdentifier(this.serialization, virtualClusterKey);
        File file = new File(this.virtualGraphServerSupport.storagePath(), String.valueOf(this.identifier) + "." + this.databaseId + ".vg." + clusterIdentifier);
        if (file.exists()) {
            VirtualCluster cluster = new VirtualCluster(virtualClusterKey);
            try {
                cluster.load(file, this.serialization, (virtualClusterKey & 1) > 0 ? this.virtualGraphServerSupport : null);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            this.clusters.set(virtualClusterKey, cluster);
            this.memoryClusters.addFirst(cluster);
            this.swap();
            return cluster;
        }
        this.clusters.set(virtualClusterKey, NO_CLUSTER);
        return null;
    }

    private void swap() {
        this.trimClusters();
        while (this.memoryClusters.size() > 30) {
            VirtualCluster remo = this.memoryClusters.removeLast();
            File file = new File(this.virtualGraphServerSupport.storagePath(), String.valueOf(this.identifier) + "." + this.databaseId + ".vg." + VirtualCluster.getClusterIdentifier(this.serialization, remo.clusterId()));
            try {
                remo.saveImpl(file, this.serialization);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.clusters.set(remo.clusterId(), null);
        }
    }

    private synchronized VirtualCluster getCluster(int subject, boolean create) {
        int clusterId = TransientGraph.getVirtualClusterKey(subject);
        VirtualCluster cluster = this.getOrLoad(clusterId);
        if (cluster != null) {
            return cluster;
        }
        if (create) {
            this.clusters.ensureCapacity(clusterId + 1);
            int i = this.clusters.size();
            while (i < clusterId + 1) {
                this.clusters.add(null);
                ++i;
            }
            cluster = new VirtualCluster(clusterId);
            this.clusters.set(clusterId, cluster);
            this.memoryClusters.addFirst(cluster);
            this.swap();
            return cluster;
        }
        return null;
    }

    private synchronized void applyValue(int subject, Object value, Binding binding) {
        try {
            Serializer serializer = Bindings.getSerializer((Binding)binding);
            byte[] serialized = serializer.serialize(value);
            VirtualCluster cluster = this.getCluster(subject, true);
            cluster.setValue(subject, serialized, serialized.length);
        }
        catch (SerializationException e) {
            e.printStackTrace();
        }
        catch (SerializerConstructionException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized void applyStatements(int subject, int[] statements) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.addStatements(subject, statements);
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    private synchronized void produceAllStatements(ReadGraphImpl graph, int subject, AsyncProcedure<Object> procedure) throws DatabaseException {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.resetLazy(subject);
        for (VirtualGraphSource source : this.sources) {
            source.getStatements((ReadGraph)graph, (VirtualGraphContext)this, subject);
        }
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    private synchronized void producePartialStatements(ReadGraphImpl graph, int subject, int predicate, AsyncProcedure<Object> procedure) throws DatabaseException {
        for (VirtualGraphSource source : this.sources) {
            source.getStatements((ReadGraph)graph, (VirtualGraphContext)this, subject, predicate);
        }
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    public int getIndex(Resource resource) {
        try {
            return this.serialization.getTransientId(resource);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public Resource getResource(int index) {
        return new ResourceImpl(this.resourceSupport, index);
    }

    public void register(VirtualGraphSource source) {
        if (this.sources.add(source)) {
            source.attach((VirtualGraphContext)this);
        }
    }

    @Override
    public void claim(int subject, int predicate, int object) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.claim(subject, predicate, object);
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    @Override
    public synchronized int[] getObjects(int subject, int predicate) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return this.EMPTY;
        }
        return cluster.getObjects(subject, predicate);
    }

    @Override
    public synchronized int[] getPredicates(int subject) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return this.EMPTY;
        }
        return cluster.getPredicates(subject);
    }

    @Override
    public synchronized byte[] getValue(int subject) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return null;
        }
        return cluster.getValue(subject);
    }

    @Override
    public int newResource(boolean isLazy) {
        int id = this.virtualGraphServerSupport.createVirtual();
        VirtualCluster cluster = this.getCluster(id, true);
        if (isLazy) {
            cluster.setLazy(id);
        }
        return id;
    }

    public void finish(int subject) {
        VirtualCluster cluster = this.getCluster(subject, false);
        cluster.finish(subject);
    }

    @Override
    public void deny(int subject, int predicate, int object) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.deny(subject, predicate, object);
    }

    @Override
    public void claimValue(int subject, byte[] data, int length) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.setValue(subject, data, length);
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    @Override
    public void denyValue(int subject) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.denyValue(subject);
        if (subject > 0) {
            this.virtualGraphServerSupport.removeVirtual(subject);
        }
    }

    public void initialise(final Write write) {
        try {
            this.sessionRequestProcessor.syncRequest((Write)new WriteRequest(this){

                public void perform(WriteGraph graph) throws DatabaseException {
                    write.perform(graph);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void postModification(AsyncRequestProcessor processor, final WriteOnly request) {
        if (processor == null) {
            processor = this.sessionRequestProcessor;
        }
        processor.asyncRequest((WriteOnly)new WriteOnlyRequest(this){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                request.perform(graph);
            }
        });
    }

    public void updateStatements(int resource, int[] statements) {
        this.applyStatements(resource, statements);
    }

    public void updateValue(int resource, Object value, Binding binding) {
        this.applyValue(resource, value, binding);
    }

    @Override
    public boolean isPending(int subject) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return false;
        }
        return cluster.isPending(subject);
    }

    @Override
    public boolean isPending(int subject, int predicate) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return false;
        }
        return cluster.isPending(subject, predicate);
    }

    @Override
    public void load(ReadGraphImpl graph, int resource, int predicate, final Callback<ReadGraphImpl> callback) throws DatabaseException {
        this.producePartialStatements(graph, resource, predicate, new AsyncProcedure<Object>(){

            public void execute(AsyncReadGraph graph, Object result) {
                callback.run((Object)((ReadGraphImpl)graph));
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                callback.run((Object)((ReadGraphImpl)graph));
            }
        });
    }

    @Override
    public void load(ReadGraphImpl graph, int resource, final Callback<ReadGraphImpl> callback) throws DatabaseException {
        this.produceAllStatements(graph, resource, new AsyncProcedure<Object>(){

            public void execute(AsyncReadGraph graph, Object result) {
                callback.run((Object)((ReadGraphImpl)graph));
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                callback.run((Object)((ReadGraphImpl)graph));
            }
        });
    }

    public Collection<Statement> listStatements() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        int i = 0;
        while (i < this.clusters.size()) {
            VirtualCluster cluster = this.getOrLoad(i);
            if (cluster != null) {
                cluster.listStatements(this.serialization, result);
            }
            ++i;
        }
        return result;
    }

    public Collection<Resource> listValues() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        int i = 0;
        while (i < this.clusters.size()) {
            VirtualCluster cluster = this.getOrLoad(i);
            if (cluster != null) {
                cluster.listValues(this.serialization, result);
            }
            ++i;
        }
        return result;
    }

    public VirtualGraph.Persistency getPersistency() {
        return this.persistency;
    }

    public String toString() {
        String result = "'" + this.identifier + "'";
        if (VirtualGraph.Persistency.WORKSPACE == this.persistency) {
            result = String.valueOf(result) + " (W)";
        } else if (VirtualGraph.Persistency.MEMORY == this.persistency) {
            result = String.valueOf(result) + " (M)";
        }
        return result;
    }
}

