/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.jpountz.lz4.bundle.Activator;

public enum Native {

    private static boolean loaded = false;
    private static boolean failedToLoad = false;

    private static String arch() {
        return System.getProperty("os.arch");
    }

    private static OS os() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Linux")) {
            return OS.LINUX;
        }
        if (osName.contains("Mac")) {
            return OS.MAC;
        }
        if (osName.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("Solaris")) {
            return OS.SOLARIS;
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + osName);
    }

    public static String resourceName() {
        OS os = Native.os();
        return "/" + os.name + "/" + Native.arch() + "/liblz4-java." + os.libExtension;
    }

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    public static synchronized boolean hasFailedToLoad() {
        return failedToLoad;
    }

    public static synchronized void load() {
        if (loaded) {
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Native.class.getClassLoader());
            if (Activator.resolvedNativeLibraryLocation != null) {
                System.load(Activator.resolvedNativeLibraryLocation.getAbsolutePath());
                loaded = true;
                return;
            }
            try {
                String resourceName = Native.resourceName();
                InputStream is = Native.class.getResourceAsStream(resourceName);
                if (is == null) {
                    failedToLoad = true;
                    throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + resourceName + ". Please try building from source.");
                }
                File tempLib = File.createTempFile("liblz4-java", "." + Native.os().libExtension);
                FileOutputStream out = new FileOutputStream(tempLib);
                try {
                    int read;
                    byte[] buf = new byte[4096];
                    while ((read = is.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                    try {
                        out.close();
                        out = null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    System.load(tempLib.getAbsolutePath());
                    loaded = true;
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (tempLib != null && tempLib.exists()) {
                        if (!loaded) {
                            tempLib.delete();
                        } else {
                            tempLib.deleteOnExit();
                        }
                    }
                }
            }
            catch (IOException e) {
                failedToLoad = true;
                throw new ExceptionInInitializerError("Cannot unpack liblz4-java");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private static enum OS {
        WINDOWS("win32", "dll"),
        LINUX("linux", "so"),
        MAC("darwin", "dylib"),
        SOLARIS("solaris", "so");

        public final String name;
        public final String libExtension;

        private OS(String name, String libExtension) {
            this.name = name;
            this.libExtension = libExtension;
        }
    }
}

