/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.lz4.LZ4JNI;
import net.jpountz.util.Utils;

final class LZ4JNIFastDecompressor
extends LZ4FastDecompressor {
    public static final LZ4JNIFastDecompressor INSTANCE = new LZ4JNIFastDecompressor();

    LZ4JNIFastDecompressor() {
    }

    @Override
    public final int decompress(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        Utils.checkRange(src, srcOff);
        Utils.checkRange(dest, destOff, destLen);
        int result = LZ4JNI.LZ4_decompress_fast(src, srcOff, dest, destOff, destLen);
        if (result < 0) {
            throw new LZ4Exception("Error decoding offset " + (srcOff - result) + " of input buffer");
        }
        return result;
    }

    @Override
    public final int decompressWithPrefix64k(byte[] src, int srcOff, byte[] dest, int destOff, int destLen) {
        Utils.checkRange(src, srcOff);
        Utils.checkRange(dest, destOff, destLen);
        int result = LZ4JNI.LZ4_decompress_fast_withPrefix64k(src, srcOff, dest, destOff, destLen);
        if (result < 0) {
            throw new LZ4Exception("Error decoding offset " + (srcOff - result) + " of input buffer");
        }
        return result;
    }
}

