/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class FastQueue<T> {
    protected List<T> data = new ArrayList<T>();
    protected int p = 0;

    public void reset() {
        this.p = 0;
        this.data.clear();
    }

    public T remove() {
        T o = this.get(0);
        ++this.p;
        if (this.p == this.data.size()) {
            this.clear();
        }
        return o;
    }

    public void add(T o) {
        this.data.add(o);
    }

    public int size() {
        return this.data.size() - this.p;
    }

    public T head() {
        return this.get(0);
    }

    public T get(int i) {
        if (this.p + i >= this.data.size()) {
            throw new NoSuchElementException("queue index " + (this.p + i) + " > size " + this.data.size());
        }
        return this.data.get(this.p + i);
    }

    public void clear() {
        this.p = 0;
        this.data.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int n = this.size();
        int i = 0;
        while (i < n) {
            buf.append(this.get(i));
            if (i + 1 < n) {
                buf.append(" ");
            }
            ++i;
        }
        return buf.toString();
    }
}

