/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal.dialogs;

import java.io.IOException;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.workbench.internal.Activator;
import org.simantics.workbench.internal.Messages;

public class SimanticsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showDatabaseControlsButton;

    protected Control createContents(Composite parent) {
        Composite composite = this.createComposite(parent);
        this.createButtons(composite);
        SimanticsPreferencePage.createSpace(composite);
        this.applyDialogFont(composite);
        return composite;
    }

    protected void createButtons(Composite composite) {
        this.createDatabaseControlPref(composite);
    }

    protected void createDatabaseControlPref(Composite composite) {
        this.showDatabaseControlsButton = new Button(composite, 32);
        this.showDatabaseControlsButton.setText(Messages.SimanticsPreferencePage_ShowDatabaseControlsButton);
        this.showDatabaseControlsButton.setToolTipText(Messages.SimanticsPreferencePage_ShowDatabaseControlsTooltip);
        this.showDatabaseControlsButton.setSelection(this.getPreferenceStore().getBoolean("SHOW_DATABASE_CONTROLS"));
    }

    protected Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        return composite;
    }

    protected static Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        return button;
    }

    protected static Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected static void createSpace(Composite parent) {
        Label vfiller = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        vfiller.setLayoutData((Object)gridData);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench aWorkbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean showDatabaseControls = store.getDefaultBoolean("SHOW_DATABASE_CONTROLS");
        this.showDatabaseControlsButton.setSelection(showDatabaseControls);
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("SHOW_DATABASE_CONTROLS", this.showDatabaseControlsButton.getSelection());
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        return true;
    }
}

