/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule.instructions;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;

public class UnlessRuleInstruction
implements IRuleInstruction {
    IInstruction condition;
    IRuleInstruction rule;

    public UnlessRuleInstruction(IInstruction condition, IRuleInstruction rule) {
        this.condition = condition;
        this.rule = rule;
    }

    @Override
    public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
        Object cont = this.condition.query(g, bindings);
        if (cont == IInstruction.FAILURE) {
            return this.rule.execute(g, bindings);
        }
        return null;
    }

    @Override
    public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
        Object cont = this.condition.query((ReadGraph)g, bindings);
        if (cont == IInstruction.FAILURE) {
            this.rule.doExecute(g, bindings);
        }
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.condition.collectVariables(reads, writes);
        this.rule.collectVariables(reads, writes);
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.condition.mapVariables(map);
        this.rule.mapVariables(map);
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("unless ");
        this.condition.toString(b, indent + 1);
        b.append('\n');
        int i = 0;
        while (i < indent) {
            b.append("     ");
            ++i;
        }
        b.append("then ");
        this.rule.toString(b, indent + 1);
    }
}

