/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule.instructions;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;

public class IfRuleInstruction
implements IRuleInstruction {
    IInstruction condition;
    IRuleInstruction rule;
    IRuleInstruction elseRule;

    public IfRuleInstruction(IInstruction condition, IRuleInstruction rule, IRuleInstruction elseRule) {
        this.condition = condition;
        this.rule = rule;
        this.elseRule = elseRule;
    }

    public IfRuleInstruction(IInstruction condition, IRuleInstruction rule) {
        this(condition, rule, null);
    }

    @Override
    public IModification execute(ReadGraph g, final Object[] bindings) throws DatabaseException {
        Object cont = this.condition.query(g, bindings);
        if (cont == IInstruction.FAILURE) {
            if (this.elseRule != null) {
                return this.elseRule.execute(g, bindings);
            }
            return null;
        }
        do {
            IModification modi;
            if ((modi = this.rule.execute(g, bindings)) == null) continue;
            if (cont == null) {
                return modi;
            }
            final Object curCont = this.condition.next(g, bindings, cont);
            if (curCont == IInstruction.FAILURE) {
                return modi;
            }
            return new IModification(){

                public void perform(WriteGraph g) throws DatabaseException {
                    modi.perform(g);
                    Object cont = curCont;
                    do {
                        IfRuleInstruction.this.rule.doExecute(g, bindings);
                    } while (cont != null && (cont = IfRuleInstruction.this.condition.next((ReadGraph)g, bindings, cont)) != IInstruction.FAILURE);
                }
            };
        } while (cont != null && (cont = this.condition.next(g, bindings, cont)) != IInstruction.FAILURE);
        return null;
    }

    @Override
    public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
        Object cont = this.condition.query((ReadGraph)g, bindings);
        if (cont == IInstruction.FAILURE) {
            if (this.elseRule != null) {
                this.elseRule.doExecute(g, bindings);
            }
            return;
        }
        do {
            this.rule.doExecute(g, bindings);
        } while (cont != null && (cont = this.condition.next((ReadGraph)g, bindings, cont)) != IInstruction.FAILURE);
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.condition.collectVariables(reads, writes);
        this.rule.collectVariables(reads, writes);
        if (this.elseRule != null) {
            this.elseRule.collectVariables(reads, writes);
        }
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.condition.mapVariables(map);
        this.rule.mapVariables(map);
        if (this.elseRule != null) {
            this.elseRule.mapVariables(map);
        }
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("if   ");
        this.condition.toString(b, indent + 1);
        b.append('\n');
        int i = 0;
        while (i < indent) {
            b.append("     ");
            ++i;
        }
        b.append("then ");
        this.rule.toString(b, indent + 1);
        if (this.elseRule != null) {
            b.append('\n');
            i = 0;
            while (i < indent) {
                b.append("     ");
                ++i;
            }
            b.append("else ");
            this.elseRule.toString(b, indent + 1);
        }
    }
}

