/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule.instructions;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;

public class DenyRuleInstruction
implements IRuleInstruction {
    IInstruction instruction;

    public DenyRuleInstruction(IInstruction instruction) {
        this.instruction = instruction;
    }

    @Override
    public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
        final IContextualModification modi = this.instruction.deny(g, bindings);
        if (modi != null) {
            final Object[] curBindings = Arrays.copyOf(bindings, bindings.length);
            return new IModification(){

                public void perform(WriteGraph g) throws DatabaseException {
                    modi.perform(g, curBindings);
                }
            };
        }
        return null;
    }

    @Override
    public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
        this.instruction.doDeny(g, bindings);
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.instruction.collectVariables(reads, writes);
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.instruction.mapVariables(map);
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("deny ");
        this.instruction.toString(b, indent + 1);
    }
}

