/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule;

import gnu.trove.TObjectIntHashMap;
import org.simantics.db.Resource;
import org.simantics.mapping.constraint.IConstraint;
import org.simantics.mapping.constraint.TooManyUnboundVariablesException;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.rule.IRule;
import org.simantics.mapping.rule.instructions.IRuleInstruction;
import org.simantics.mapping.rule.instructions.IfRuleInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class IfRule
implements IRule {
    IConstraint condition;
    IRule thenRule;
    IRule elseRule;

    public IfRule(IConstraint condition, IRule thenRule, IRule elseRule) {
        this.condition = condition;
        this.thenRule = thenRule;
        this.elseRule = elseRule;
    }

    public IfRule(IConstraint condition, IRule thenRule) {
        this(condition, thenRule, null);
    }

    @Override
    public ImmutableSet<Resource> binds() {
        ImmutableSet ret = this.condition.binds().addAll(this.thenRule.binds());
        if (this.elseRule != null) {
            ret = ret.addAll(this.elseRule.binds());
        }
        return ret;
    }

    @Override
    public IRuleInstruction createInstruction(TObjectIntHashMap<Resource> variableIds, ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
        IInstruction conditionInstruction = this.condition.createInstruction(variableIds, bound);
        bound = bound.addAll(this.condition.binds());
        return new IfRuleInstruction(conditionInstruction, this.thenRule.createInstruction(variableIds, (ImmutableSet<Resource>)bound), this.elseRule == null ? null : this.elseRule.createInstruction(variableIds, (ImmutableSet<Resource>)bound));
    }
}

