/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.TripletInstruction;

public class TripletPredicateObjectQuery
extends TripletInstruction {
    Resource predicate;

    public TripletPredicateObjectQuery(int variable0, int variable1, int variable2, Resource predicate) {
        super(variable0, variable1, variable2);
        this.predicate = predicate;
    }

    public TripletPredicateObjectQuery(int variable0, int variable1, int variable2) {
        this(variable0, variable1, variable2, null);
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        Collection result;
        Resource r0 = (Resource)bindings[this.variable0];
        Collection collection = result = this.predicate == null ? g.getStatements(r0, Layer0.getInstance((ReadGraph)g).IsWeaklyRelatedTo) : g.getStatements(r0, this.predicate);
        if (result.isEmpty()) {
            return IInstruction.FAILURE;
        }
        Iterator it = result.iterator();
        Statement stat = (Statement)it.next();
        bindings[this.variable1] = stat.getPredicate();
        bindings[this.variable2] = stat.getObject();
        if (it.hasNext()) {
            return it;
        }
        return null;
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation) {
        Iterator it = (Iterator)continuation;
        if (it.hasNext()) {
            Statement stat = (Statement)it.next();
            bindings[this.variable1] = stat.getPredicate();
            bindings[this.variable2] = stat.getObject();
            if (it.hasNext()) {
                return it;
            }
            return null;
        }
        return IInstruction.FAILURE;
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        super.collectVariables(reads, writes);
        writes.add(this.variable1);
        writes.add(this.variable2);
    }
}

