/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint.instructions;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;

public abstract class CombinedInstruction
implements IInstruction {
    IInstruction[] instructions;

    public CombinedInstruction(IInstruction ... instructions) {
        this.instructions = instructions;
    }

    @Override
    public IContextualModification claim(ReadGraph g, Object[] bindings) throws DatabaseException {
        int instructionId = 0;
        while (instructionId < this.instructions.length) {
            IContextualModification modification = this.instructions[instructionId].claim(g, bindings);
            if (modification != null) {
                if (instructionId == this.instructions.length - 1) {
                    return modification;
                }
                return new CompositeClaim(modification, instructionId);
            }
            ++instructionId;
        }
        return null;
    }

    @Override
    public IContextualModification deny(ReadGraph g, Object[] bindings) throws DatabaseException {
        int instructionId = 0;
        while (instructionId < this.instructions.length) {
            IContextualModification modification = this.instructions[instructionId].deny(g, bindings);
            if (modification != null) {
                if (instructionId == this.instructions.length - 1) {
                    return modification;
                }
                return new CompositeDeny(modification, instructionId);
            }
            ++instructionId;
        }
        return null;
    }

    @Override
    public void doClaim(WriteGraph g, Object[] bindings) throws DatabaseException {
        int i = 0;
        while (i < this.instructions.length) {
            this.instructions[i].doClaim(g, bindings);
            ++i;
        }
    }

    @Override
    public void doDeny(WriteGraph g, Object[] bindings) throws DatabaseException {
        int i = 0;
        while (i < this.instructions.length) {
            this.instructions[i].doDeny(g, bindings);
            ++i;
        }
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        IInstruction[] iInstructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            IInstruction inst = iInstructionArray[n2];
            inst.collectVariables(reads, writes);
            ++n2;
        }
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        IInstruction[] iInstructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            IInstruction inst = iInstructionArray[n2];
            inst.mapVariables(map);
            ++n2;
        }
    }

    class CompositeClaim
    implements IContextualModification {
        IContextualModification modification;
        int instructionId;

        public CompositeClaim(IContextualModification modification, int instructionId) {
            this.modification = modification;
            this.instructionId = instructionId;
        }

        @Override
        public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
            this.modification.perform(g, bindings);
            int i = this.instructionId + 1;
            while (i < CombinedInstruction.this.instructions.length) {
                CombinedInstruction.this.instructions[i].doClaim(g, bindings);
                ++i;
            }
        }
    }

    class CompositeDeny
    implements IContextualModification {
        IContextualModification modification;
        int instructionId;

        public CompositeDeny(IContextualModification modification, int instructionId) {
            this.modification = modification;
            this.instructionId = instructionId;
        }

        @Override
        public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
            this.modification.perform(g, bindings);
            int i = this.instructionId + 1;
            while (i < CombinedInstruction.this.instructions.length) {
                CombinedInstruction.this.instructions[i].doDeny(g, bindings);
                ++i;
            }
        }
    }
}

