/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint;

import gnu.trove.TObjectIntHashMap;
import org.simantics.db.Resource;
import org.simantics.mapping.constraint.IConstraint;
import org.simantics.mapping.constraint.TooManyUnboundVariablesException;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.TripletInstruction;
import org.simantics.mapping.constraint.instructions.TripletObjectQuery;
import org.simantics.mapping.constraint.instructions.TripletPredicateObjectQuery;
import org.simantics.mapping.constraint.instructions.TripletPredicateQuery;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class TripletConstraint
implements IConstraint {
    Resource variable0;
    Resource variable1;
    Resource variable2;
    Resource predicate;

    public TripletConstraint(Resource variable0, Resource variable1, Resource variable2, Resource predicate) {
        this.variable0 = variable0;
        this.variable1 = variable1;
        this.variable2 = variable2;
        this.predicate = predicate;
    }

    public TripletConstraint(Resource variable0, Resource variable1, Resource variable2) {
        this(variable0, variable1, variable2, null);
    }

    @Override
    public ImmutableSet<Resource> binds() {
        return ImmutableSet.of((Comparable[])new Resource[]{this.variable0, this.variable1, this.variable2});
    }

    @Override
    public IInstruction createInstruction(TObjectIntHashMap<Resource> variableIds, ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
        int id0 = variableIds.get((Object)this.variable0);
        int id1 = variableIds.get((Object)this.variable1);
        int id2 = variableIds.get((Object)this.variable2);
        if (bound.contains((Comparable)this.variable0)) {
            if (bound.contains((Comparable)this.variable1)) {
                if (bound.contains((Comparable)this.variable2)) {
                    return new TripletInstruction(id0, id1, id2);
                }
                return new TripletObjectQuery(id0, id1, id2);
            }
            if (bound.contains((Comparable)this.variable2)) {
                return new TripletPredicateQuery(id0, id1, id2, this.predicate);
            }
            return new TripletPredicateObjectQuery(id0, id1, id2, this.predicate);
        }
        throw new TooManyUnboundVariablesException();
    }

    @Override
    public int isApplicable(ImmutableSet<Resource> bound) {
        if (bound.contains((Comparable)this.variable0)) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }
}

