/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.constraint;

import gnu.trove.TObjectIntHashMap;
import org.simantics.db.Resource;
import org.simantics.mapping.constraint.IConstraint;
import org.simantics.mapping.constraint.TooManyUnboundVariablesException;
import org.simantics.mapping.constraint.instructions.AndInstruction;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.utils.datastructures.persistent.ImmutableSet;

public class ConstraintConjunction
implements IConstraint {
    IConstraint[] constraints;

    public ConstraintConjunction(IConstraint ... constraints) {
        this.constraints = constraints;
    }

    @Override
    public ImmutableSet<Resource> binds() {
        ImmutableSet ret = ImmutableSet.empty();
        IConstraint[] iConstraintArray = this.constraints;
        int n = this.constraints.length;
        int n2 = 0;
        while (n2 < n) {
            IConstraint c = iConstraintArray[n2];
            ret = ret.addAll(c.binds());
            ++n2;
        }
        return ret;
    }

    @Override
    public IInstruction createInstruction(TObjectIntHashMap<Resource> variableIds, ImmutableSet<Resource> bound) throws TooManyUnboundVariablesException {
        IInstruction[] instructions = new IInstruction[this.constraints.length];
        int i = 0;
        while (i < this.constraints.length) {
            instructions[i] = this.constraints[i].createInstruction(variableIds, bound);
            bound = bound.addAll(this.constraints[i].binds());
            ++i;
        }
        return new AndInstruction(instructions);
    }

    @Override
    public int isApplicable(ImmutableSet<Resource> bound) {
        int ret = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.constraints.length) {
            int temp = this.constraints[i].isApplicable(bound);
            if (temp < ret) {
                if (temp == 0) {
                    return 0;
                }
                ret = temp;
            }
            bound = bound.addAll(this.constraints[i].binds());
            ++i;
        }
        return ret;
    }
}

