/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.strings.format;

import java.util.ArrayList;
import java.util.List;
import org.simantics.utils.strings.format.MetricsFormat;
import org.simantics.utils.strings.format.MetricsFormatListListener;

public class MetricsFormatList {
    public static MetricsFormat METRICS_GENERIC = new MetricsFormat("%s", 1.0, "Generic");
    public static MetricsFormat METRICS_EXPONENT2 = new MetricsFormat("%e", 1.0, "Exponent");
    public static MetricsFormat METRICS_EXPONENT = new MetricsFormat("D0.##E0", 1.0, "Exponent");
    public static MetricsFormat METRICS_DECIMAL = new MetricsFormat("D0.0###", 1.0, "Decimal");
    public static MetricsFormat METRICS_DECIMAL2 = new MetricsFormat("D0.####", 1.0, "Decimal");
    public static MetricsFormat METRICS_DECIMAL3 = new MetricsFormat("%,g", 1.0, "Decimal");
    public static MetricsFormat METRICS_DATE_FI = new MetricsFormat("%td.%tm.%ty", 1.0, "Date dd.mm.yyyy");
    public static MetricsFormat METRICS_DATE_IMPERIAL = new MetricsFormat("%tm/%td/%ty", 1.0, "Date mm/dd/yyyy");
    public static MetricsFormat METRICS_TIME_SECONDS = new MetricsFormat("%tS.%tL", 1.0, "Time, ss.ms");
    public static MetricsFormat METRICS_CLOCK_TIME = new MetricsFormat("%tH:%tM:%tS.%tL", 1.0, "Time, hh:mm:ss.ms");
    public static MetricsFormat METRICS_CLOCK_TIME2 = new MetricsFormat("%tH:%tM:%tS", 1.0, "Time, hh:mm:ss");
    private final List<MetricsFormat> formats = new ArrayList<MetricsFormat>();
    private final List<MetricsFormatListListener> listeners = new ArrayList<MetricsFormatListListener>();
    private static MetricsFormatList list = new MetricsFormatList();

    static {
        list.addDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsFormat[] getFormats() {
        List<MetricsFormat> list = this.formats;
        synchronized (list) {
            return this.formats.toArray(new MetricsFormat[0]);
        }
    }

    private void addDefaults() {
        try {
            this.addFormat(METRICS_DECIMAL);
            this.addFormat(METRICS_DECIMAL2);
            this.addFormat(METRICS_DECIMAL3);
            this.addFormat(METRICS_EXPONENT);
            this.addFormat(METRICS_EXPONENT2);
            this.addFormat(METRICS_GENERIC);
            this.addFormat(METRICS_DATE_FI);
            this.addFormat(METRICS_DATE_IMPERIAL);
            this.addFormat(METRICS_TIME_SECONDS);
            this.addFormat(METRICS_CLOCK_TIME);
            this.addFormat(METRICS_CLOCK_TIME2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MetricsFormatListListener listener) {
        MetricsFormatList metricsFormatList = this;
        synchronized (metricsFormatList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MetricsFormatListListener listener) {
        MetricsFormatList metricsFormatList = this;
        synchronized (metricsFormatList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListChanged() {
        MetricsFormatList metricsFormatList = this;
        synchronized (metricsFormatList) {
            for (MetricsFormatListListener listener : this.listeners) {
                listener.onListChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsFormat addFormat(MetricsFormat format) throws Exception {
        MetricsFormatList metricsFormatList = this;
        synchronized (metricsFormatList) {
            MetricsFormat old = this.findEqual(format);
            if (old != null) {
                throw new Exception("Format already exists");
            }
            this.formats.add(format);
            this.fireListChanged();
            return format;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFormat(MetricsFormat format) throws Exception {
        MetricsFormatList metricsFormatList = this;
        synchronized (metricsFormatList) {
            int index = this.formats.indexOf(format);
            if (index < 0) {
                throw new Exception("Format not found");
            }
            this.formats.remove(format);
            this.fireListChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsFormat replaceFormatWith(MetricsFormat oldFormat, MetricsFormat newFormat) throws Exception {
        MetricsFormatList metricsFormatList = this;
        synchronized (metricsFormatList) {
            if (this.formats.contains(newFormat)) {
                throw new Exception("New format already exists");
            }
            if (oldFormat == newFormat) {
                throw new Exception("No changes");
            }
            int index = this.formats.indexOf(oldFormat);
            if (index < 0) {
                throw new Exception("Format not found");
            }
            this.formats.remove(index);
            this.formats.add(index, newFormat);
            this.fireListChanged();
            return newFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsFormat findEqual(MetricsFormat format) {
        MetricsFormatList metricsFormatList = this;
        synchronized (metricsFormatList) {
            int i;
            block4: {
                i = this.formats.indexOf(format);
                if (i >= 0) break block4;
                return null;
            }
            return this.formats.get(i);
        }
    }

    public MetricsFormat findByIndex(int index) {
        return this.formats.get(index);
    }

    public int findIndex(MetricsFormat format) {
        int i = 0;
        while (i < this.formats.size()) {
            if (this.formats.get(i).equals(format)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static MetricsFormatList getList() {
        return list;
    }
}

