/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.strings.format;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatException;

public class MetricsFormat
implements Serializable {
    private static final long serialVersionUID = 8036591251300342995L;
    private String pattern;
    private String internalPattern;
    private String[] internalPatternDivided;
    private boolean canUseDecimals = false;
    private double scale;
    private String name;
    private int hash;
    private boolean isDouble = true;
    private boolean useDecimalFormat = false;
    private Object[] args = new Object[1];

    public String getName() {
        return this.name;
    }

    public MetricsFormat(String pattern, double scale, String name) throws IllegalArgumentException {
        this.scale = scale;
        pattern = this.setPattern(pattern);
        this.internalPattern = this.formatPattern(pattern);
        this.internalPatternDivided = this.formatPatternDivided(pattern);
        this.name = name;
        this.hash = this.makeHash();
    }

    public MetricsFormat(String pattern, double scale) throws IllegalArgumentException {
        this.scale = scale;
        pattern = this.setPattern(pattern);
        this.internalPattern = this.formatPattern(pattern);
        this.internalPatternDivided = this.formatPatternDivided(pattern);
        this.name = "";
        this.hash = this.makeHash();
    }

    public MetricsFormat(String pattern) throws IllegalArgumentException {
        this.scale = 1.0;
        pattern = this.setPattern(pattern);
        this.internalPattern = this.formatPattern(pattern);
        this.internalPatternDivided = this.formatPatternDivided(pattern);
        this.name = "";
        this.hash = this.makeHash();
    }

    private String setPattern(String pattern) {
        this.pattern = pattern;
        if (pattern.startsWith("D")) {
            pattern = pattern.substring(1);
            this.useDecimalFormat = true;
        } else {
            if (pattern.startsWith("S")) {
                pattern = pattern.substring(1);
            }
            this.useDecimalFormat = false;
        }
        return pattern;
    }

    private String formatPattern(String pattern) {
        int pos = 0;
        if (!this.useDecimalFormat) {
            while ((pos = pattern.indexOf(37, pos)) >= 0) {
                if (pos == 0 || pattern.indexOf(pos - 1) != 92) {
                    pattern = String.valueOf(pattern.substring(0, pos + 1)) + "1$" + pattern.substring(pos + 1, pattern.length());
                    pos += 3;
                    continue;
                }
                ++pos;
            }
        }
        double value = 0.0;
        if (this.useDecimalFormat) {
            this.isDouble = true;
            this.useDecimalFormat = true;
            this.canUseDecimals = false;
            DecimalFormat format = new DecimalFormat(pattern);
            format.format(value);
        } else {
            try {
                this.isDouble = true;
                this.useDecimalFormat = false;
                this.args[0] = value;
                String.format(pattern, this.args);
            }
            catch (IllegalFormatConversionException e1) {
                try {
                    this.isDouble = false;
                    this.useDecimalFormat = false;
                    this.args[0] = (long)value;
                    String.format(pattern, this.args);
                }
                catch (Exception e2) {
                    throw e1;
                }
            }
        }
        return pattern;
    }

    private String[] formatPatternDivided(String pattern) {
        String[] divPattern = new String[]{"", ""};
        if (this.useDecimalFormat) {
            return divPattern;
        }
        int pos = 0;
        while ((pos = pattern.indexOf(37, pos)) >= 0) {
            if (pos == 0 || pattern.indexOf(pos - 1) != 92) {
                char c;
                char c2;
                divPattern[0] = String.valueOf(pattern.substring(0, pos + 1)) + "1$";
                divPattern[1] = pattern.substring(pos + 1, pattern.length());
                int pos2 = 0;
                while ((c2 = divPattern[1].charAt(pos2)) == '-' || c2 == '#' || c2 == '+' || c2 == ' ' || c2 == '0' || c2 == ',' || c2 == '(' || Character.isDigit(c2)) {
                    ++pos2;
                }
                int pos3 = pos2;
                while ((c = divPattern[1].charAt(pos3)) == '.' || Character.isDigit(c)) {
                    ++pos3;
                }
                this.canUseDecimals = c == 'f' || c == 'F';
                if (pos2 > 0 || pos3 > 0) {
                    divPattern[0] = String.valueOf(divPattern[0]) + divPattern[1].substring(0, pos2);
                    divPattern[1] = divPattern[1].substring(pos3, divPattern[1].length());
                }
                pos += 3;
                break;
            }
            ++pos;
        }
        double value = 0.0;
        try {
            this.args[0] = value;
            String.format(String.valueOf(divPattern[0]) + ".2" + divPattern[1], this.args);
        }
        catch (IllegalFormatException e1) {
            try {
                pattern = this.formatPattern(pattern);
                this.isDouble = false;
                this.args[0] = (long)value;
                String.format(pattern, this.args);
                divPattern[0] = null;
                divPattern[1] = null;
                this.canUseDecimals = false;
            }
            catch (Exception e2) {
                throw e1;
            }
        }
        return divPattern;
    }

    public String formatValue(double value) {
        return this._formatValue(this.internalPattern, value);
    }

    public String formatValue(double value, int numDecimals) {
        if (this.canUseDecimals) {
            if (numDecimals < 0) {
                numDecimals = 0;
            }
            return this._formatValue(value, numDecimals);
        }
        return this._formatValue(this.internalPattern, value);
    }

    private String _formatValue(String pattern, double value) {
        if (!this.useDecimalFormat) {
            if (this.isDouble) {
                this.args[0] = value;
                return String.format(pattern, this.args);
            }
            this.args[0] = new Long((long)value);
            return String.format(pattern, this.args);
        }
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(value);
    }

    private String _formatValue(double value, int decimals) {
        this.args[0] = value;
        return String.format(String.valueOf(this.internalPatternDivided[0]) + "." + decimals + this.internalPatternDivided[1], this.args);
    }

    public String getPattern() {
        return this.pattern;
    }

    public double getScale() {
        return this.scale;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (this == null && obj != null) {
            return false;
        }
        if (obj == null && this != null) {
            return false;
        }
        if (!(obj instanceof MetricsFormat)) {
            return false;
        }
        MetricsFormat other = (MetricsFormat)obj;
        if (other.hash != this.hash) {
            return false;
        }
        return other.pattern.equals(this.pattern) && other.scale == this.scale && other.name.equals(this.name);
    }

    private int makeHash() {
        long longBits = Double.doubleToLongBits(this.scale);
        int scaleHash = (int)longBits ^ (int)(longBits << 16);
        return this.pattern.hashCode() ^ scaleHash ^ this.name.hashCode();
    }

    public int hashCode() {
        return this.hash;
    }
}

