/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.strings;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class StringUtils {
    private static NumberFormat usFormat = DecimalFormat.getInstance(Locale.US);
    public static final String ZERO_LENGTH_STRING = "";

    public static String safeString(String input) {
        if (input != null) {
            return input;
        }
        return ZERO_LENGTH_STRING;
    }

    public static double safeDouble(String input) {
        if (input == null) {
            return Double.NaN;
        }
        try {
            String usafied = input.replace(",", ".");
            Number number = usFormat.parse(usafied);
            return number.doubleValue();
        }
        catch (ParseException e) {
            return Double.NaN;
        }
    }

    public static String repeat(String pattern, int repeatCount) {
        StringBuilder sb = new StringBuilder(pattern.length() * repeatCount);
        int i = 0;
        while (i < repeatCount) {
            sb.append(pattern);
            ++i;
        }
        return sb.toString();
    }
}

