/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.simantics.utils.bytes.ByteArrays;

public class EString {
    public static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] LF = new byte[]{10};

    public static byte[] toBytes(String s) {
        int size = s.length();
        byte[] array = new byte[size];
        int i = 0;
        while (i < size) {
            array[i] = (byte)s.charAt(i);
            ++i;
        }
        return array;
    }

    public static String toString(byte[] array) {
        if (array == null) {
            return null;
        }
        int size = array.length;
        if (size == 0) {
            return null;
        }
        char[] chars = new char[size];
        int i = 0;
        while (i < size) {
            chars[i] = (char)(array[i] & 0xFF);
            ++i;
        }
        return new String(chars);
    }

    public static String PChar(byte[] array, int offset) {
        if (array == null) {
            return null;
        }
        int size = array.length;
        int zero = offset;
        while (zero < size && array[zero] != 0) {
            ++zero;
        }
        if (zero >= size) {
            throw new IndexOutOfBoundsException();
        }
        char[] chars = new char[zero - offset];
        int i = 0;
        while (i < chars.length) {
            chars[i] = (char)(array[i + offset] & 0xFF);
            ++i;
        }
        return new String(chars);
    }

    public static String PChar(byte[] array, int offset, int maxLen) {
        if (array == null) {
            return null;
        }
        int size = array.length;
        if (offset + maxLen < size) {
            size = offset + maxLen;
        }
        int zero = offset;
        while (zero < size && array[zero] != 0) {
            ++zero;
        }
        if (zero >= size) {
            throw new IndexOutOfBoundsException();
        }
        char[] chars = new char[zero - offset];
        int i = 0;
        while (i < chars.length) {
            chars[i] = (char)(array[i + offset] & 0xFF);
            ++i;
        }
        return new String(chars);
    }

    public static String[] explode(String str, String breaker) {
        return str.split(breaker);
    }

    public static String[] explode(String str) {
        return str.split("\n");
    }

    public static String implode(Object[] strings, String glue) {
        if (strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0].toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(strings[0].toString());
        int i = 1;
        while (i < strings.length) {
            sb.append(glue);
            sb.append(strings[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String implode(Collection<?> strings) {
        return EString.implode(strings.toArray(new Object[strings.size()]));
    }

    public static String implode(Collection<?> strings, String glue) {
        return EString.implode(strings.toArray(new Object[strings.size()]), glue);
    }

    public static String implode(Object[] strings) {
        if (strings.length == 0) {
            return "";
        }
        int len = 0;
        int i = 0;
        while (i < strings.length) {
            len += strings[i].toString().length() + 1;
            ++i;
        }
        int pos = 0;
        byte[] data = new byte[len];
        int i2 = 0;
        while (i2 < strings.length) {
            String s = strings[i2].toString();
            byte[] sdata = s.getBytes();
            System.arraycopy(sdata, 0, data, pos, sdata.length);
            System.arraycopy(LF, 0, data, pos + sdata.length, 1);
            pos += sdata.length + 1;
            ++i2;
        }
        return new String(data);
    }

    public static String[] addPrefix(String[] strings, String prefix) {
        String[] result = new String[strings.length];
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(prefix) + strings[i];
            ++i;
        }
        return result;
    }

    public static String addPrefix(String strings, String prefix) {
        Object[] result = EString.explode(strings);
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(prefix) + (String)result[i];
            ++i;
        }
        return EString.implode(result);
    }

    public static String addFix(String strings, String prefix, String suffix) {
        Object[] result = EString.explode(strings);
        int i = 0;
        while (i < result.length) {
            result[i] = String.valueOf(prefix) + (String)result[i] + suffix;
            ++i;
        }
        return EString.implode(result);
    }

    public static String intToBEHex(int value, int decimals) {
        String result = "";
        int i = 0;
        while (i < decimals) {
            result = String.valueOf(result) + HEX_VALUES[value >> 4 & 0xF];
            result = String.valueOf(result) + HEX_VALUES[value & 0xF];
            value >>= 8;
            ++i;
        }
        return result;
    }

    public static String wordWrap(String text, int minWidth, int maxWidth) {
        char cr = '\r';
        String[] lines = text.replaceAll("" + cr, "").split("\n");
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (line.length() < maxWidth) {
                result.add(line);
            } else {
                String[] words = lines[i].split(" ");
                line = "";
                int j = 0;
                while (j < words.length) {
                    if (line.equals("")) {
                        line = words[j];
                        while (line.length() > maxWidth) {
                            result.add(line.substring(0, maxWidth));
                            line = line.substring(maxWidth);
                        }
                    } else {
                        String word = words[j];
                        if (line.length() + 1 + word.length() < maxWidth) {
                            line = String.valueOf(line) + " " + word;
                        } else if (line.length() >= minWidth) {
                            result.add(line);
                            line = word;
                        } else {
                            line = String.valueOf(line) + " " + word;
                            while (line.length() > maxWidth) {
                                result.add(line.substring(0, maxWidth));
                                line = line.substring(maxWidth);
                            }
                        }
                    }
                    ++j;
                }
                if (!line.equals("")) {
                    result.add(line);
                }
            }
            ++i;
        }
        text = "";
        i = 0;
        while (i < result.size()) {
            text = String.valueOf(text) + (String)result.get(i) + "\n";
            ++i;
        }
        return text;
    }

    public static void printByteArray(byte[] array) {
        int i = 0;
        while (i < array.length) {
            System.out.print(array[i] & 0xFF);
            if (i < array.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
    }

    public static void saveToFile(String text, String filename) throws IOException {
        ByteArrays.saveToFile(EString.toBytes(text), filename);
    }

    public static String escapeString(String str, String escapeSet, char escapeChar) {
        escapeSet = String.valueOf(escapeSet) + escapeChar;
        StringBuilder sb = new StringBuilder(str.length() * 2);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            int j = 0;
            while (j < escapeSet.length()) {
                char ec = escapeSet.charAt(j);
                if (ec == c) {
                    sb.append(escapeChar);
                    break;
                }
                ++j;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static String unescapeString(String str, char escapeChar) {
        StringBuilder sb = new StringBuilder(str.length());
        boolean prevWasEscapeChar = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (prevWasEscapeChar || c != escapeChar) {
                prevWasEscapeChar = false;
                sb.append(c);
            } else {
                prevWasEscapeChar = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String scanEscapedString(String str, char escapeChar, char endMark) {
        StringBuilder sb = new StringBuilder(str.length());
        boolean prevWasEscapeChar = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (prevWasEscapeChar || c != escapeChar) {
                if (!prevWasEscapeChar && c == endMark) {
                    return sb.toString();
                }
                prevWasEscapeChar = false;
            } else {
                prevWasEscapeChar = true;
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static Pattern compileSimplePattern(String patternStr) throws PatternSyntaxException {
        String str = "";
        int i = 0;
        while (i < patternStr.length()) {
            char c = patternStr.charAt(i);
            str = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' ? String.valueOf(str) + c : (c == '?' ? String.valueOf(str) + ".?" : (c == '*' ? String.valueOf(str) + ".*" : String.valueOf(str) + "\\" + c));
            ++i;
        }
        return Pattern.compile(str);
    }

    public static boolean simplePatternMatch(String str, String simplePattern) {
        try {
            Pattern ptr = EString.compileSimplePattern(simplePattern);
            Matcher m = ptr.matcher(str);
            return m.matches();
        }
        catch (PatternSyntaxException pse) {
            return false;
        }
    }

    public static void main(String[] args) {
        System.out.println(EString.escapeString("value=5,\\5", ",=", '\\'));
        System.out.println(EString.unescapeString("value\\=5\\,\\\\5", '\\'));
        System.out.println(EString.scanEscapedString("val\\,ue\\=5\\,\\\\5,value2=xxx", '\\', ','));
        System.out.println(EString.scanEscapedString("\\,\\,,\\,\\,", '\\', ','));
        String value = "STRING 01234\u0080\u0081\u00ff";
        int X = 500;
        System.out.println(String.valueOf(X) + " = " + EString.intToBEHex(X, 4));
        byte[] array = EString.toBytes(value);
        System.out.print(value);
        System.out.print(" = ");
        EString.printByteArray(array);
        System.out.println();
        String str = EString.toString(array);
        System.out.print(value);
        System.out.print(" = ");
        EString.printByteArray(array);
        System.out.println();
        String text = "Reads b.length bytes from this file into the byte array, starting at the current file pointer. This method reads repeatedly from the file until the requested number of bytes are read. This method blocks until the requested number of bytes are read, the end of the stream is detected, or an exception is thrown";
        text = EString.wordWrap(text, 20, 30);
        System.out.println(text);
        ArrayList<String> v = new ArrayList<String>();
        v.add("jeps");
        v.add("jops");
        v.add("kops");
        v.add("hops");
        System.out.println(String.valueOf(EString.implode(v)) + "\n");
    }
}

