/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.strings;

import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.Comparator;

public class AlphanumComparator
implements Comparator<Object> {
    private static final CaseInsensitiveComparator CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    public static final AlphanumComparator COMPARATOR = new AlphanumComparator(null);
    public static final AlphanumComparator CASE_INSENSITIVE_COMPARATOR = new AlphanumComparator(CASE_INSENSITIVE_ORDER);
    private final Comparator<CharBuffer> comparator;

    private AlphanumComparator(Comparator<CharBuffer> comparator) {
        this.comparator = comparator;
    }

    private final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    /*
     * Unable to fully structure code
     */
    private final CharBuffer getChunk(String s, int slength, int marker, CharBuffer chunk) {
        block5: {
            if (chunk == null) {
                chunk = CharBuffer.allocate(slength);
            } else {
                chunk.rewind();
                chunk.limit(chunk.capacity());
            }
            c = s.charAt(marker);
            chunk.append(c);
            ++marker;
            if (!this.isDigit(c)) ** GOTO lbl26
            while (marker < slength) {
                c = s.charAt(marker);
                if (this.isDigit(c)) {
                    chunk.append(c);
                    ++marker;
                    continue;
                }
                break block5;
            }
            break block5;
            while (!this.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
lbl26:
                // 2 sources

                if (marker < slength) continue;
            }
        }
        chunk.limit(chunk.position());
        chunk.rewind();
        return chunk;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        CharBuffer thisChunk = null;
        CharBuffer thatChunk = null;
        while (thisMarker < s1Length && thatMarker < s2Length) {
            thisChunk = this.getChunk(s1, s1Length, thisMarker, thisChunk);
            thisMarker += thisChunk.limit();
            thatChunk = this.getChunk(s2, s2Length, thatMarker, thatChunk);
            thatMarker += thatChunk.limit();
            int result = 0;
            if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.limit();
                result = thisChunkLength - thatChunk.limit();
                if (result == 0) {
                    int i = 0;
                    while (i < thisChunkLength) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result != 0) {
                            return result;
                        }
                        ++i;
                    }
                }
            } else {
                int n = result = this.comparator != null ? this.comparator.compare(thisChunk, thatChunk) : thisChunk.compareTo(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    private static class CaseInsensitiveComparator
    implements Comparator<CharBuffer>,
    Serializable {
        private static final long serialVersionUID = 5247677019801470582L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(CharBuffer s1, CharBuffer s2) {
            int n1 = s1.limit();
            int n2 = s2.limit();
            int i1 = 0;
            int i2 = 0;
            while (i1 < n1 && i2 < n2) {
                char c2;
                char c1 = s1.charAt(i1);
                if (c1 != (c2 = s2.charAt(i2)) && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2))) {
                    return c1 - c2;
                }
                ++i1;
                ++i2;
            }
            return n1 - n2;
        }
    }
}

