/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.page;

public class MarginUtils {
    public static final Margin NO_MARGIN = MarginUtils.marginOf(0.0, 0.0, 0.0);
    public static final Margin MARGIN5 = MarginUtils.marginOf(5.0, 0.0, 0.0);
    public static final Margin MARGIN2 = MarginUtils.marginOf(2.0, 0.0, 0.0);
    public static final Margin MARGIN_10mm = MarginUtils.marginOf(0.0, 0.0, 10.0);
    public static final Margins NO_MARGINS = new Margins(NO_MARGIN, NO_MARGIN, NO_MARGIN, NO_MARGIN);
    public static final Margins MARGINS5 = new Margins(MARGIN5, MARGIN5, MARGIN5, MARGIN5);
    public static final Margins MARGINS2 = new Margins(MARGIN2, MARGIN2, MARGIN2, MARGIN2);
    public static final Margins MARGINS_10mm = new Margins(MARGIN_10mm, MARGIN_10mm, MARGIN_10mm, MARGIN_10mm);

    public static Margin marginOf(double controlRelative, double controlAbsolute, double diagramAbsolute) {
        return new Margin(controlRelative / 100.0, controlAbsolute, diagramAbsolute);
    }

    public static class Margin {
        public final double controlRelative;
        public final double controlAbsolute;
        public final double diagramAbsolute;

        public Margin(double controlRelative, double controlAbsolute, double diagramAbsolute) {
            this.controlRelative = controlRelative;
            this.controlAbsolute = controlAbsolute;
            this.diagramAbsolute = diagramAbsolute;
        }

        public String toString() {
            return "(" + this.controlRelative + " " + this.controlAbsolute + " " + this.diagramAbsolute + ")";
        }

        public boolean isZero() {
            return Math.abs(this.controlRelative) < Double.MIN_VALUE && Math.abs(this.controlAbsolute) < Double.MIN_VALUE && Math.abs(this.diagramAbsolute) < Double.MIN_VALUE;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.controlAbsolute);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.controlRelative);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.diagramAbsolute);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Margin other = (Margin)obj;
            if (Double.doubleToLongBits(this.controlAbsolute) != Double.doubleToLongBits(other.controlAbsolute)) {
                return false;
            }
            if (Double.doubleToLongBits(this.controlRelative) != Double.doubleToLongBits(other.controlRelative)) {
                return false;
            }
            return Double.doubleToLongBits(this.diagramAbsolute) == Double.doubleToLongBits(other.diagramAbsolute);
        }
    }

    public static class Margins {
        public static final int TOP = 1;
        public static final int BOTTOM = 2;
        public static final int LEFT = 4;
        public static final int RIGHT = 8;
        public final Margin top;
        public final Margin bottom;
        public final Margin left;
        public final Margin right;

        public Margins(Margin top, Margin bottom, Margin left, Margin right) {
            assert (top != null);
            assert (bottom != null);
            assert (left != null);
            assert (right != null);
            this.top = top;
            this.bottom = bottom;
            this.left = left;
            this.right = right;
        }

        public Margins withSide(int side, Margin m) {
            Margin t = (side & 1) != 0 ? m : this.top;
            Margin b = (side & 2) != 0 ? m : this.bottom;
            Margin l = (side & 4) != 0 ? m : this.left;
            Margin r = (side & 8) != 0 ? m : this.right;
            return new Margins(t, b, l, r);
        }

        public boolean isZero() {
            return this.top.isZero() && this.bottom.isZero() && this.left.isZero() && this.right.isZero();
        }

        public String toString() {
            return "[top=" + this.top + ", bottom=" + this.bottom + ", left=" + this.left + ", right=" + this.right + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.bottom.hashCode();
            result = 31 * result + this.left.hashCode();
            result = 31 * result + this.right.hashCode();
            result = 31 * result + this.top.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Margins other = (Margins)obj;
            if (!this.top.equals(other.top)) {
                return false;
            }
            if (!this.bottom.equals(other.bottom)) {
                return false;
            }
            if (!this.left.equals(other.left)) {
                return false;
            }
            return this.right.equals(other.right);
        }
    }
}

