/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.logging;

import java.util.Properties;

public abstract class Logger {
    public static final boolean ECHO = false;
    protected final org.apache.log4j.Logger logger;

    protected static final Properties defaultProperties(String ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0);
        Properties defaultProperties = new Properties();
        defaultProperties.put("log4j.rootCategory", "ERROR, default");
        defaultProperties.put("log4j.appender.default", "org.apache.log4j.FileAppender");
        defaultProperties.put("log4j.appender.default.append", "false");
        defaultProperties.put("log4j.appender.default.layout", "org.apache.log4j.PatternLayout");
        defaultProperties.put("log4j.appender.default.layout.ConversionPattern", "%-6r [%15.15t] %-5p %30.30c - %m%n");
        int i = 0;
        while (i < keyValuePairs.length) {
            String key = keyValuePairs[i++];
            String value = keyValuePairs[i++];
            defaultProperties.put(key, value);
        }
        return defaultProperties;
    }

    protected Logger(org.apache.log4j.Logger logger) {
        this.logger = logger;
    }

    protected final org.apache.log4j.Logger getLogger() {
        return this.logger;
    }

    public void logTrace(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.getLogger().trace((Object)message, exception);
    }

    public void logInfo(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.getLogger().info((Object)message, exception);
    }

    public void logError(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.getLogger().error((Object)message, exception);
    }

    public void logWarning(String message, Throwable exception) {
        if (exception == null) {
            exception = new RuntimeException();
        }
        this.getLogger().error((Object)message, exception);
    }
}

