/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.format;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public static final Pattern PATTERN = Pattern.compile("(-)?(?:(\\d+)y *)?(?:(\\d+)d *)?(?:(?:(\\d{1,}):)??(?:(\\d{1,2}):)?(\\d{1,2}))?(?:\\.(\\d+))?");
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    double maxValue;
    int decimals;
    RoundingMode rounding = RoundingMode.HALF_UP;
    MathContext decimalRoundingContext;

    public TimeFormat(double maxValue, int decimals) {
        this.maxValue = maxValue;
        this.decimals = decimals;
        this.decimalRoundingContext = new MathContext(Math.max(1, decimals + 1), this.rounding);
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
        this.decimalRoundingContext = new MathContext(Math.max(1, decimals + 1), this.rounding);
    }

    public void setRounding(RoundingMode rounding) {
        this.rounding = rounding;
        this.decimalRoundingContext = new MathContext(Math.max(1, this.decimals + 1), rounding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer stringBuffer = toAppendTo;
        synchronized (stringBuffer) {
            return this.formatSync(obj, toAppendTo, pos);
        }
    }

    private StringBuffer formatSync(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        long xl;
        double x = ((Number)obj).doubleValue();
        int initLen = toAppendTo.length();
        if (x < 0.0) {
            toAppendTo.append("-");
            x = -x;
            initLen = toAppendTo.length();
        }
        BigDecimal decimalPart = new BigDecimal(x - Math.floor(x) + 1.0);
        boolean needToRound = TWO.compareTo(decimalPart = decimalPart.round(this.decimalRoundingContext)) == 0;
        double max = Math.max(this.maxValue, x);
        long l = xl = needToRound ? Math.round(x) : (long)Math.floor(x);
        if (xl >= 31536000L) {
            long years = xl / 31536000L;
            toAppendTo.append(years);
            toAppendTo.append("y");
        }
        if (xl >= 86400L) {
            if (toAppendTo.length() != initLen) {
                toAppendTo.append(' ');
            }
            long days = xl % 31536000L / 86400L;
            toAppendTo.append(days);
            toAppendTo.append("d");
        }
        if (this.decimals >= -5) {
            if (toAppendTo.length() != initLen) {
                toAppendTo.append(' ');
            }
            long seconds = xl % 86400L;
            if (max >= 1440.0) {
                long hh = seconds / 3600L;
                if (x > 3600.0) {
                    toAppendTo.append(hh / 10L);
                }
                toAppendTo.append(hh % 10L);
                toAppendTo.append(":");
            }
            if (max >= 60.0) {
                long mm = seconds / 60L % 60L;
                toAppendTo.append(mm / 10L);
                toAppendTo.append(mm % 10L);
                toAppendTo.append(":");
            }
            long ss = seconds % 60L;
            if (x >= 10.0 || initLen != toAppendTo.length()) {
                toAppendTo.append(ss / 10L);
            }
            toAppendTo.append(ss % 10L);
            if (this.decimals > 0) {
                toAppendTo.append('.');
                String dps = decimalPart.toString();
                int decimalPartLen = dps.length();
                int trailingZeros = this.decimals;
                if (decimalPartLen > 2) {
                    toAppendTo.append(dps, 2, decimalPartLen);
                    trailingZeros -= decimalPartLen - 2;
                }
                int d = 0;
                while (d < trailingZeros) {
                    toAppendTo.append('0');
                    ++d;
                }
            }
        }
        if (toAppendTo.length() == initLen) {
            toAppendTo.append('-');
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        Matcher m = PATTERN.matcher(source);
        if (!m.matches()) {
            try {
                return Double.parseDouble(source);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("TimeFormat.parseObject('" + source + "') failed", m.regionStart());
            }
        }
        String negG = m.group(1);
        String yearG = m.group(2);
        String dayG = m.group(3);
        String hourG = m.group(4);
        String minuteG = m.group(5);
        String secondG = m.group(6);
        String decimalG = m.group(7);
        boolean negative = negG == null ? false : negG.equals("-");
        double years = yearG == null ? 0.0 : Double.parseDouble(yearG);
        double days = dayG == null ? 0.0 : Double.parseDouble(dayG);
        double hours = hourG == null ? 0.0 : Double.parseDouble(hourG);
        double minutes = minuteG == null ? 0.0 : Double.parseDouble(minuteG);
        double seconds = secondG == null ? 0.0 : Double.parseDouble(secondG);
        double decimals = decimalG == null ? 0.0 : Double.parseDouble(decimalG) / Math.pow(10.0, decimalG.length());
        double value = years * 3.1536E7 + days * 86400.0 + hours * 3600.0 + minutes * 60.0 + seconds + decimals;
        if (negative) {
            value = -value;
        }
        return value;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        try {
            return this.parseObject(source);
        }
        catch (ParseException e) {
            pos.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }
}

