/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.format;

import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.simantics.utils.format.FormattingUtil;
import org.simantics.utils.format.SwitchFormat;

public class FormattingUtils {
    public static final FormattingUtil US;
    public static final FormattingUtil DEFAULT;

    static {
        DEFAULT = US = new FormattingUtil(5, 5, Locale.US);
    }

    public static String engineeringFormat(Object value) {
        return DEFAULT.engineeringFormat(value);
    }

    public static Format significantDigitFormat(int withSignificantDigits) {
        return FormattingUtils.significantDigitFormat(withSignificantDigits, false);
    }

    public static Format significantDigitFormat(int withSignificantDigits, boolean stripTrailingZeros) {
        if (withSignificantDigits < 1) {
            throw new IllegalArgumentException("withSignificantDigits must be > 0, got " + withSignificantDigits);
        }
        StringBuilder sb = new StringBuilder(withSignificantDigits + 3);
        sb.append("0.");
        int i = 0;
        while (i < withSignificantDigits - 1) {
            sb.append("#");
            ++i;
        }
        sb.append("E0");
        DecimalFormat low = new DecimalFormat(sb.toString());
        ((NumberFormat)low).setGroupingUsed(false);
        SignificantDigitFormat hi = new SignificantDigitFormat(withSignificantDigits, stripTrailingZeros);
        SwitchFormat format = new SwitchFormat(0.1, 1.0, low, hi, hi);
        return format;
    }

    private static class SignificantDigitFormat
    extends NumberFormat {
        private static final long serialVersionUID = 1079268918077141671L;
        private MathContext mc;
        private boolean stripTrailingZeros;
        private boolean fixDecimalSeparator;
        private char decimalSeparator;

        public SignificantDigitFormat(int digits, boolean stripTrailingZeros) {
            this.mc = new MathContext(digits);
            this.stripTrailingZeros = stripTrailingZeros;
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance();
            this.decimalSeparator = symbols.getDecimalSeparator();
            this.fixDecimalSeparator = this.decimalSeparator != '.';
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            BigDecimal big = new BigDecimal(number, this.mc);
            if (this.stripTrailingZeros) {
                big = big.stripTrailingZeros();
            }
            String str = big.toString();
            if (this.fixDecimalSeparator) {
                str = str.replace('.', this.decimalSeparator);
            }
            return toAppendTo.append(str);
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(number);
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return 0;
        }
    }
}

