/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.Adapter;
import org.simantics.databoard.adapter.AdapterConstructionException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.utils.ExtensionFilter;
import org.simantics.utils.bytes.LEInt;

public class FileUtils {
    private static final int IO_BUFFER_SIZE = 65536;

    public static String escapeFileName(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String unescapeFileName(String filename) {
        try {
            return URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static File ensureParentDirectoryExists(String path) throws IOException {
        return FileUtils.ensureParentDirectoryExists(new File(path));
    }

    public static File ensureParentDirectoryExists(File path) throws IOException {
        return FileUtils.ensureDirectoryExists(path.getParentFile());
    }

    public static File ensureDirectoryExists(String path) throws IOException {
        return FileUtils.ensureDirectoryExists(new File(path));
    }

    public static File ensureDirectoryExists(File path) throws IOException {
        if (path.isDirectory()) {
            return path;
        }
        if (path.exists()) {
            throw new IOException("file '" + path + "', already exists but it is not a directory");
        }
        path.mkdirs();
        if (!path.exists()) {
            throw new IOException("could not create directory '" + path + "' for an unknown reason");
        }
        return path;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(sourceFile);
            fos = new FileOutputStream(destFile);
            FileChannel source = fis.getChannel();
            FileChannel destination = fos.getChannel();
            long count = 0L;
            long size = source.size();
            while (count < size) {
                count += destination.transferFrom(source, count, size - count);
            }
        }
        catch (Throwable throwable) {
            if (fis != null) {
                FileUtils.uncheckedClose(fis);
            }
            if (fos != null) {
                FileUtils.uncheckedClose(fos);
            }
            throw throwable;
        }
        if (fis != null) {
            FileUtils.uncheckedClose(fis);
        }
        if (fos != null) {
            FileUtils.uncheckedClose(fos);
        }
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            if (!dst.exists()) {
                dst.mkdir();
            }
            String[] stringArray = src.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File dstFile = new File(dst, file);
                FileUtils.copy(srcFile, dstFile);
                ++n2;
            }
        } else {
            FileUtils.copyFile(src, dst);
        }
    }

    public static byte[] readFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            long size = file.length();
            if (size > Integer.MAX_VALUE) {
                throw new IOException("File too big");
            }
            int len = (int)size;
            byte[] data = new byte[len];
            int pos = 0;
            while ((long)pos < size) {
                int read = fis.read(data, pos, len - pos);
                pos += read;
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    public static void writeFile(File file, byte[] data) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        try {
            raf.setLength(data.length);
            raf.seek(0L);
            raf.write(data);
        }
        finally {
            raf.close();
        }
    }

    public static String getContents(InputStream stream) throws IOException {
        return FileUtils.getContents(stream, Charset.defaultCharset());
    }

    public static String getContents(InputStream stream, Charset charset, String lineSeparator) throws IOException {
        StringBuilder contents = new StringBuilder();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader(stream, charset));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(lineSeparator);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }

    public static String getContents(File f) throws IOException {
        return FileUtils.getContents(f, Charset.defaultCharset());
    }

    public static String getContents(File f, Charset charset) throws IOException {
        return FileUtils.getContents((InputStream)new FileInputStream(f), charset);
    }

    public static String getContents(InputStream stream, Charset charset) throws IOException {
        return FileUtils.getContents(stream, charset, System.getProperty("line.separator"));
    }

    public static String getContents(InputStream stream, String lineSeparator) throws IOException {
        return FileUtils.getContents(stream, Charset.defaultCharset(), lineSeparator);
    }

    public static String getContents(String sourcePath) throws IOException {
        return FileUtils.getContents(sourcePath, Charset.defaultCharset(), System.getProperty("line.separator"));
    }

    public static String getContents(String sourcePath, String lineSeparator) throws IOException {
        return FileUtils.getContents(sourcePath, Charset.defaultCharset(), lineSeparator);
    }

    public static String getContents(String sourcePath, Charset charset) throws IOException {
        return FileUtils.getContents(sourcePath, charset, System.getProperty("line.separator"));
    }

    public static String getContents(String sourcePath, Charset charset, String lineSeparator) throws IOException {
        String string;
        FileInputStream input = null;
        try {
            input = new FileInputStream(sourcePath);
            string = FileUtils.getContents(input, charset, lineSeparator);
        }
        catch (Throwable throwable) {
            FileUtils.uncheckedClose(input);
            throw throwable;
        }
        FileUtils.uncheckedClose(input);
        return string;
    }

    public static String getContents(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("null URL");
        }
        InputStream input = null;
        try {
            input = url.openStream();
            String string = FileUtils.getContents(input);
            return string;
        }
        finally {
            FileUtils.uncheckedClose(input);
        }
    }

    public static Object readFile(InputStream stream, Binding binding) throws IOException {
        Binding datatype_binding = Bindings.getBindingUnchecked(Datatype.class);
        Datatype type = (Datatype)Bindings.getSerializerUnchecked((Binding)datatype_binding).deserialize(stream);
        if (type.equals((Object)binding.type())) {
            return Bindings.getSerializerUnchecked((Binding)binding).deserialize(stream);
        }
        try {
            Binding fileContentBinding = Bindings.getMutableBinding((Datatype)type);
            Adapter adapter = Bindings.adapterFactory.getAdapter(fileContentBinding, binding, true, false);
            Object value = Bindings.getSerializerUnchecked((Binding)fileContentBinding).deserialize(stream);
            return adapter.adapt(value);
        }
        catch (AdapterConstructionException e) {
            throw new IOException(e);
        }
        catch (AdaptException e) {
            throw new IOException(e);
        }
    }

    public static void deleteAll(File dir) throws IOException {
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        if (dir.isDirectory()) {
            File[] fs = dir.listFiles((FileFilter)null);
            if (fs == null) {
                return;
            }
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FileUtils.deleteAll(f);
                } else if (!f.delete()) {
                    throw new IOException("Could not delete file: " + f.getAbsolutePath());
                }
                ++n2;
            }
            if (!dir.delete()) {
                throw new IOException("Could not delete directory: " + dir.getAbsolutePath());
            }
        } else if (dir.exists() && !dir.delete()) {
            throw new IOException("Could not delete file: " + dir.getAbsolutePath());
        }
    }

    public static void deleteAllWithFilter(File dir, ArrayList<String> filter) throws IOException {
        if (dir.isFile() && !filter.contains(dir.getAbsolutePath())) {
            dir.delete();
            return;
        }
        if (dir.isDirectory()) {
            File[] fs = dir.listFiles((FileFilter)null);
            if (fs == null) {
                return;
            }
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FileUtils.deleteAllWithFilter(f, filter);
                } else if (!filter.contains(f.getAbsolutePath()) && !f.delete()) {
                    throw new IOException("Could not delete file: " + f.getAbsolutePath());
                }
                ++n2;
            }
            if (!filter.contains(dir.getAbsolutePath()) && !dir.delete()) {
                throw new IOException("Could not delete directory: " + dir.getAbsolutePath());
            }
        } else if (dir.exists() && filter.contains(dir.getAbsolutePath()) && !dir.delete()) {
            throw new IOException("Could not delete file: " + dir.getAbsolutePath());
        }
    }

    public static ArrayList<String> createFileFilter(File dir, ArrayList<String> filter) {
        if (filter == null) {
            filter = new ArrayList();
        }
        if (dir.isFile()) {
            filter.add(dir.getAbsolutePath());
            return filter;
        }
        if (dir.isDirectory()) {
            File[] fs = dir.listFiles((FileFilter)null);
            if (fs == null) {
                return filter;
            }
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    FileUtils.createFileFilter(f, filter);
                } else {
                    filter.add(f.getAbsolutePath());
                }
                ++n2;
            }
            filter.add(dir.getAbsolutePath());
        } else if (dir.exists()) {
            filter.add(dir.getAbsolutePath());
        }
        return filter;
    }

    public static boolean deleteDir(File dir) {
        Logger myLogger = Logger.getLogger(FileUtils.class);
        myLogger.debug((Object)("Deleting directory " + dir));
        boolean result = true;
        if (!dir.isDirectory()) {
            return false;
        }
        File[] fs = dir.listFiles();
        if (fs != null) {
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    result &= FileUtils.deleteDir(f);
                }
                if (f.isFile()) {
                    result &= f.delete();
                }
                ++n2;
            }
        }
        boolean ok = dir.delete();
        return result &= ok;
    }

    public static String deleteDirs(File dir) {
        Logger myLogger = Logger.getLogger(FileUtils.class);
        myLogger.debug((Object)("Deleting directory " + dir));
        boolean result = true;
        if (!dir.isDirectory()) {
            return dir + " is not a directory!";
        }
        File[] fs = dir.listFiles();
        if (fs != null) {
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                boolean a;
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    a = FileUtils.deleteDir(f);
                    result &= a;
                }
                if (f.isFile()) {
                    a = f.delete();
                    result &= a;
                }
                ++n2;
            }
        }
        boolean ok = dir.delete();
        return "deleteDirs succesful for " + dir + " : " + (result &= ok);
    }

    public static void uncheckedClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File copyResource(URL url, File targetFile, boolean deleteOnExit) throws IOException, FileNotFoundException {
        File file;
        if (url == null) {
            throw new IllegalArgumentException("null url");
        }
        FileOutputStream os = null;
        InputStream is = null;
        try {
            int read;
            if (targetFile.exists()) {
                targetFile.delete();
            }
            is = url.openStream();
            byte[] buffer = new byte[16384];
            os = new FileOutputStream(targetFile);
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            os.close();
            is.close();
            if (deleteOnExit) {
                targetFile.deleteOnExit();
            }
            file = targetFile;
        }
        catch (Throwable throwable) {
            FileUtils.uncheckedClose(os);
            FileUtils.uncheckedClose(is);
            throw throwable;
        }
        FileUtils.uncheckedClose(os);
        FileUtils.uncheckedClose(is);
        return file;
    }

    public static File getOrCreateTemporaryDirectory(boolean requireEmptyDirectory, String ... pathSegments) throws IOException {
        String separator = System.getProperty("file.separator");
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null) {
            throw new IllegalStateException("'java.io.tmpdir' property is not defined, is the system TMP environment variable defined?");
        }
        if (!FileUtils.hasTrailingSeparator(tempDir)) {
            tempDir = String.valueOf(tempDir) + separator;
        }
        int i = 0;
        while (i < pathSegments.length - 1) {
            if (FileUtils.containsSeparator(pathSegments[i])) {
                throw new IllegalArgumentException("path segments contain path separators: " + Arrays.toString(pathSegments));
            }
            tempDir = String.valueOf(pathSegments[i]) + separator;
            ++i;
        }
        if (pathSegments.length > 0) {
            String lastSegment = pathSegments[pathSegments.length - 1];
            String suffix = "";
            int counter = 0;
            while (true) {
                File temp;
                if (!(temp = new File(String.valueOf(tempDir) + lastSegment + suffix)).exists()) {
                    if (temp.mkdirs()) {
                        return temp;
                    }
                } else if (temp.isDirectory() && temp.canWrite()) {
                    if (requireEmptyDirectory) {
                        String[] files = temp.list();
                        if (files != null && files.length == 0) {
                            return temp;
                        }
                    } else {
                        return temp;
                    }
                }
                suffix = Integer.toHexString(counter);
                ++counter;
            }
        }
        return new File(tempDir);
    }

    private static boolean containsSeparator(String s) {
        return s.contains("/") || s.contains("\\");
    }

    private static boolean hasTrailingSeparator(String s) {
        return s.endsWith("/") || s.endsWith("\\");
    }

    public static byte[] deflate(byte[] input) {
        Deflater compresser = new Deflater(9);
        compresser.setInput(input);
        compresser.finish();
        int bufferSize = input.length < 16 ? 16 : input.length;
        byte[] buffer = new byte[bufferSize];
        int bufferPos = 0;
        do {
            int compressedDataLength = compresser.deflate(buffer, bufferPos, buffer.length - bufferPos);
            bufferPos += compressedDataLength;
            if (compresser.finished()) continue;
            buffer = Arrays.copyOf(buffer, buffer.length + bufferSize);
        } while (!compresser.finished());
        byte[] result = new byte[bufferPos + 4];
        System.arraycopy(buffer, 0, result, 4, bufferPos);
        byte[] sizeData = LEInt.toBytes(input.length);
        System.arraycopy(sizeData, 0, result, 0, 4);
        return result;
    }

    public static byte[] inflate(byte[] input) throws DataFormatException {
        int inflatedSize = LEInt.toInt(input);
        Inflater decompresser = new Inflater();
        decompresser.setInput(input, 4, input.length - 4);
        byte[] result = new byte[inflatedSize];
        int resultLength = decompresser.inflate(result);
        assert (resultLength == inflatedSize);
        decompresser.end();
        return result;
    }

    public static boolean isValidFileName(String name) {
        File f = new File(name);
        if (!f.exists()) {
            try {
                boolean ok = f.createNewFile();
                if (ok) {
                    f.delete();
                }
                return ok;
            }
            catch (IOException ioe) {
                return false;
            }
        }
        return true;
    }

    public static File createTmpDir() {
        String tmp = System.getenv("tmp");
        if (tmp == null) {
            tmp = "c:/temp";
        }
        Random r = new Random();
        String randomName = "simantics-tmp-" + (r.nextInt(10000) + 10000);
        File tmpDir = new File(String.valueOf(tmp) + "/" + randomName);
        tmpDir.deleteOnExit();
        Boolean ok = tmpDir.mkdirs();
        if (!ok.booleanValue()) {
            throw new RuntimeException("tmp dir " + tmpDir + " was not created");
        }
        return tmpDir;
    }

    public static void compressZip(String sourcePath, String zipDir) throws IOException {
        Logger myLogger = Logger.getLogger(FileUtils.class);
        myLogger.debug((Object)("Compressing file " + sourcePath + " to zip " + zipDir + "."));
        System.out.println("Compressing file " + sourcePath + " to zip " + zipDir + ".");
        File filesource = new File(sourcePath);
        URI base = filesource.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(filesource);
        FileOutputStream fout = new FileOutputStream(zipDir);
        OutputStream res = fout;
        try {
            ZipOutputStream zout = new ZipOutputStream(fout);
            res = zout;
            while (!queue.isEmpty()) {
                filesource = (File)queue.pop();
                File[] fileArray = filesource.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    String name = base.relativize(child.toURI()).getPath();
                    if (child.isDirectory()) {
                        queue.push(child);
                        name = name.endsWith("/") ? name : String.valueOf(name) + "/";
                        zout.putNextEntry(new ZipEntry(name));
                    } else {
                        zout.putNextEntry(new ZipEntry(name));
                        FileUtils.copy(child, zout);
                        zout.closeEntry();
                    }
                    ++n2;
                }
            }
        }
        finally {
            res.close();
            myLogger.debug((Object)"Filecompression done.");
            System.out.println("Filecompression done.");
        }
    }

    private static void copy(File file, ZipOutputStream zout) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            FileUtils.copy(in, (OutputStream)zout);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static void extractZip(File zipFile, File dst) throws IOException {
        Logger myLogger = Logger.getLogger(FileUtils.class);
        myLogger.debug((Object)("Extracting zip " + zipFile));
        FileInputStream fis = new FileInputStream(zipFile);
        try {
            FileUtils.extractZip(fis, dst);
        }
        finally {
            fis.close();
        }
    }

    public static void extractZip(InputStream zipInput, File dst) throws IOException {
        Logger myLogger = Logger.getLogger(FileUtils.class);
        byte[] buf = new byte[8192];
        ZipInputStream zis = new ZipInputStream(zipInput);
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            String name = entry.getName();
            myLogger.debug((Object)("Extracting " + name));
            File file = new File(dst, name);
            if (entry.isDirectory()) {
                if (!file.exists()) {
                    file.mkdirs();
                }
            } else {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileOutputStream fileoutputstream = new FileOutputStream(file);
                try {
                    try {
                        int n = 0;
                        while ((n = zis.read(buf, 0, buf.length)) > -1) {
                            fileoutputstream.write(buf, 0, n);
                        }
                    }
                    catch (ZipException e) {
                        throw new IOException("Failed to extract '" + name + "'.", e);
                    }
                }
                finally {
                    fileoutputstream.close();
                }
            }
            zis.closeEntry();
            entry = zis.getNextEntry();
        }
        zis.close();
    }

    public static void main(String[] args) {
        try {
            String str = "abcdefghijklmnopqrstuvwxyz";
            byte[] data = str.getBytes();
            System.out.println("Data:\t" + data.length);
            byte[] deflated = FileUtils.deflate(data);
            System.out.println("Deflated:\t" + deflated.length);
            byte[] inflated = FileUtils.inflate(deflated);
            System.out.println("Inflated:\t" + inflated.length);
            String str2 = new String(inflated);
            System.out.println("Strings are equal: " + str.endsWith(str2));
        }
        catch (DataFormatException e) {
            e.printStackTrace();
        }
    }

    public static File[] listFilesByExtension(File directory, String extension) {
        return directory.listFiles(new ExtensionFilter(extension));
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] b = new byte[65536];
        while ((read = in.read(b)) >= 0) {
            out.write(b, 0, read);
        }
    }

    public static long copy(InputStream in, OutputStream out, long maxBytesToCopy) throws IOException {
        byte[] b = new byte[65536];
        int read = 0;
        while ((long)read < maxBytesToCopy) {
            int l = (int)Math.min(65536L, maxBytesToCopy - (long)read);
            int r = in.read(b, 0, l);
            if (r < 0) break;
            out.write(b, 0, r);
            read += r;
        }
        return read;
    }
}

