/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph.layer;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.layer.GraphLayer;
import org.simantics.layer0.Layer0;

public final class GraphLayerUtil {
    WriteGraph graph;
    Layer0 l0;
    DiagramResource dia;

    public GraphLayerUtil(WriteGraph graph) {
        this.graph = graph;
        this.l0 = Layer0.getInstance((ReadGraph)graph);
        this.dia = DiagramResource.getInstance((ReadGraph)graph);
    }

    public GraphLayer createLayer(String layerName, boolean active) throws DatabaseException {
        Resource layer = this.graph.newResource();
        this.graph.claim(layer, this.l0.InstanceOf, null, this.dia.Layer);
        Resource visibleTag = this.newTag(this.dia.IsVisible);
        Resource focusableTag = this.newTag(this.dia.IsFocusable);
        this.graph.claim(layer, this.dia.HasVisibleTag, visibleTag);
        this.graph.claim(layer, this.dia.HasFocusableTag, focusableTag);
        Resource name = this.graph.newResource();
        this.graph.claim(name, this.l0.InstanceOf, null, this.l0.String);
        this.graph.claimValue(name, (Object)layerName);
        this.graph.claim(layer, this.l0.HasName, name);
        this.graph.claim(visibleTag, this.l0.HasName, name);
        this.graph.claim(focusableTag, this.l0.HasName, name);
        this.setLayerActive(layer, active);
        return new GraphLayer(layerName, layer, visibleTag, focusableTag);
    }

    public Resource newTag(Resource baseTag) throws DatabaseException {
        Resource tag = this.graph.newResource();
        this.graph.claim(tag, this.l0.SubrelationOf, baseTag);
        this.graph.claim(tag, this.l0.InverseOf, tag);
        return tag;
    }

    public void setLayerActive(Resource layer, boolean active) throws ManyObjectsForFunctionalRelationException, ServiceException {
        this.graph.claimLiteral(layer, this.dia.IsActive, (Object)active);
    }
}

