/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.modeling.ModelingResources;

public class TransformElement
extends ModificationAdapter {
    IElement element;

    public TransformElement(IElement element) {
        super(LOW_PRIORITY);
        this.element = element;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        DiagramMutator mutator = (DiagramMutator)ElementUtils.getDiagram((IElement)this.element).getHint(DiagramHints.KEY_MUTATOR);
        Resource elementResource = (Resource)mutator.backendObject(this.element);
        if (elementResource == null) {
            return;
        }
        AffineTransform tr = (AffineTransform)this.element.getHint(ElementHints.KEY_TRANSFORM);
        if (tr != null) {
            DiagramGraphUtil.setTransform(g, elementResource, tr);
        }
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        Resource component = g.getPossibleObject(elementResource, MOD.ElementToComponent);
        if (component != null) {
            g.addMetadata((Metadata)cm.add("Transformed " + NameUtils.getSafeName((ReadGraph)g, (Resource)component)));
        } else {
            g.addMetadata((Metadata)cm.add("Transformed " + elementResource));
        }
    }
}

