/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;

public class SetElementProperty
extends ModificationAdapter {
    ISynchronizationContext context;
    Resource diagram;
    Resource element;
    Resource property;
    Object value;

    public SetElementProperty(ISynchronizationContext context, IDiagram d, IElement edge, Object property, Object value) {
        super(REMOVE_NODE_PRIORITY);
        assert (context != null);
        assert (d != null);
        assert (edge != null);
        this.context = context;
        this.diagram = (Resource)d.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        assert (this.diagram != null);
        IElement element = ElementUtils.getParent((IElement)edge);
        Object object = element.getHint(ElementHints.KEY_OBJECT);
        if (!(object instanceof Resource)) {
            throw new UnsupportedOperationException("Setting property of element which does not have a Resource as KEY_OBJECT!\n\telement=" + element + "\n\telement class=" + element.getElementClass());
        }
        this.element = (Resource)object;
        this.property = (Resource)property;
        this.value = value;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        g.claimLiteral(this.element, this.property, this.value);
    }
}

