/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.util.HashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.layer0.Layer0;
import org.simantics.scl.commands.Commands;

public class RemoveElement
extends ModificationAdapter {
    Resource diagram;
    Resource removedElement;

    public RemoveElement(Resource diagram, Resource removed) {
        super(REMOVE_NODE_PRIORITY);
        if (diagram == null) {
            throw new NullPointerException();
        }
        if (removed == null) {
            throw new NullPointerException();
        }
        this.diagram = diagram;
        this.removedElement = removed;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        Commands.get((ReadGraph)g, (String)"Simantics/Diagram/removeElement").execute((RequestProcessor)g, (Resource)g.syncRequest((Read)new IndexRoot(this.diagram)), new Object[]{this.diagram, this.removedElement});
    }

    public static void removeElement(WriteGraph g, Resource diagram, Resource removedElement) throws DatabaseException {
        boolean connection = g.isInstanceOf(removedElement, DiagramResource.getInstance((ReadGraph)g).Connection);
        String elementName = "";
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        g.deny(removedElement, DIA.IsVisible);
        g.deny(removedElement, DIA.IsFocusable);
        if (connection) {
            ConnectionUtil cu = new ConnectionUtil(g);
            cu.removeConnection(removedElement);
        } else {
            String problem;
            Remover r = RemoverUtil.getPossibleRemover((ReadGraph)g, (Resource)removedElement);
            if (r != null && (problem = r.canRemove((ReadGraph)g, new HashMap(4))) != null) {
                throw new CannotRemoveException(problem);
            }
            Resource elementType = g.getPossibleType(removedElement, DiagramResource.getInstance((ReadGraph)g).Element);
            if (elementType != null) {
                ElementWriter writer = (ElementWriter)g.adapt(elementType, ElementWriter.class);
                writer.removeFromGraph(g, removedElement);
            }
            OrderedSetUtils.remove((WriteGraph)g, (Resource)diagram, (Resource)removedElement);
            elementName = (String)g.getPossibleRelatedValue2(removedElement, Layer0.getInstance((ReadGraph)g).HasName, (Binding)Bindings.STRING);
            RemoverUtil.remove((WriteGraph)g, (Resource)removedElement);
        }
        CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
        g.addMetadata((Metadata)cm.add("Removed element " + elementName + " " + removedElement));
        g.markUndoPoint();
    }
}

