/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.util.ArrayDeque;
import java.util.Deque;
import org.simantics.db.RequestProcessor;
import org.simantics.db.request.Write;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.diagram.synchronization.IModification;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.ThreadingModificationProxy;
import org.simantics.diagram.synchronization.graph.ModificationProcessRequest;
import org.simantics.utils.threads.IThreadWorkQueue;

public class ModificationQueue
implements IModificationQueue {
    private final RequestProcessor writebackProcessor;
    private final ErrorHandler errorHandler;
    private final Deque<IModification> writebackQueue = new ArrayDeque<IModification>();

    public ModificationQueue(RequestProcessor writebackProcessor, ErrorHandler errorHandler) {
        this.writebackProcessor = writebackProcessor;
        this.errorHandler = errorHandler;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModificationProcessRequest createModificationRequest() {
        IModification[] mods = IModification.NONE;
        Deque<IModification> deque = this.writebackQueue;
        synchronized (deque) {
            mods = this.writebackQueue.toArray(IModification.NONE);
            this.writebackQueue.clear();
        }
        return new ModificationProcessRequest(this.errorHandler, mods);
    }

    void dispatchModifications() {
        this.writebackProcessor.asyncRequest((Write)this.createModificationRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardModifications() {
        IModification[] discarded = IModification.NONE;
        Deque<IModification> deque = this.writebackQueue;
        synchronized (deque) {
            discarded = this.writebackQueue.toArray(discarded);
            this.writebackQueue.clear();
        }
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println("--------------------------------------------------------------------------------");
            System.out.println(Thread.currentThread() + " Discarded " + discarded.length + " graph modifications:");
            IModification[] iModificationArray = discarded;
            int n = discarded.length;
            int n2 = 0;
            while (n2 < n) {
                IModification m = iModificationArray[n2];
                System.out.println("    " + m);
                ++n2;
            }
            System.out.println("--------------------------------------------------------------------------------");
        }
    }

    @Override
    public boolean offer(IModification m) {
        return this.offer(m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(IModification m, IThreadWorkQueue completionThread) {
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println(Thread.currentThread() + " Offering graph modification: " + m);
        }
        Deque<IModification> deque = this.writebackQueue;
        synchronized (deque) {
            if (completionThread != null) {
                return this.writebackQueue.add(new ThreadingModificationProxy(m, completionThread, false));
            }
            return this.writebackQueue.add(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void async(IModification m, IThreadWorkQueue completionThread) {
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println(Thread.currentThread() + " Posting asynchronous graph modification: " + m);
        }
        Deque<IModification> deque = this.writebackQueue;
        synchronized (deque) {
            this.offer(m, completionThread);
            this.dispatchModifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sync(IModification m) throws InterruptedException {
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println(Thread.currentThread() + " Posting synchronous graph modification: " + m);
        }
        var2_2 = m;
        synchronized (var2_2) {
            var3_3 = this.writebackQueue;
            synchronized (var3_3) {
                this.writebackQueue.add(m);
                this.dispatchModifications();
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                if (true) ** GOTO lbl18
            }
            do {
                m.wait();
lbl18:
                // 2 sources

            } while (!m.isComplete());
            m.completed();
        }
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println(Thread.currentThread() + " Synchronous graph modification completed: " + m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Deque<IModification> deque = this.writebackQueue;
        synchronized (deque) {
            if (this.writebackQueue.isEmpty()) {
                return;
            }
        }
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println(Thread.currentThread() + " Flushing graph modification queue of size " + this.writebackQueue.size());
        }
        this.dispatchModifications();
    }

    @Override
    public void finish() throws InterruptedException {
        this.doFinish();
    }

    public void safeFinish(boolean force) {
        try {
            this.doFinish();
        }
        catch (InterruptedException e) {
            this.errorHandler.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinish() throws InterruptedException {
        Deque<IModification> deque = this.writebackQueue;
        synchronized (deque) {
            if (this.writebackQueue.isEmpty()) {
                return;
            }
        }
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println(Thread.currentThread() + " Waiting for graph modification queue to be finished");
        }
        ModificationAdapter flush = new ModificationAdapter(ModificationAdapter.LOW_PRIORITY){

            @Override
            public String toString() {
                return "FLUSH_MODIFICATION_QUEUE";
            }
        };
        this.sync(flush);
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println(Thread.currentThread() + " Graph modification queue finished");
        }
    }
}

