/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.internal.timing.GTask;
import org.simantics.diagram.internal.timing.Timing;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.diagram.synchronization.IModification;

public class ModificationProcessRequest
extends WriteRequest {
    ErrorHandler errorHandler;
    IModification[] modifications;

    public ModificationProcessRequest(ErrorHandler errorHandler, IModification[] modifications) {
        this.errorHandler = errorHandler;
        this.modifications = modifications;
    }

    public void perform(final WriteGraph g) throws DatabaseException {
        if (DebugPolicy.DEBUG_GRAPH_WRITEBACK) {
            System.out.println(Thread.currentThread() + " Performing " + this.modifications.length + " modifications");
        }
        Timing.timed(this.modifications.length + " MODIFICATIONS", new GTask(){

            @Override
            public void run() throws DatabaseException {
                IModification[] iModificationArray = ModificationProcessRequest.this.modifications;
                int n = ModificationProcessRequest.this.modifications.length;
                int n2 = 0;
                while (n2 < n) {
                    IModification m = iModificationArray[n2];
                    if (m != null) {
                        ModificationProcessRequest.this.modification(g, m);
                    }
                    ++n2;
                }
            }
        });
    }

    public void modification(final WriteGraph g, final IModification m) throws DatabaseException {
        g.markUndoPoint();
        Timing.timed(m.toString(), new GTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws DatabaseException {
                IModification iModification = m;
                synchronized (iModification) {
                    block11: {
                        try {
                            if (DebugPolicy.DEBUG_GRAPH_WRITEBACK_MODIFICATION) {
                                System.out.println(Thread.currentThread() + "  Performing modification: " + m);
                            }
                            m.perform(g);
                        }
                        catch (Exception e) {
                            m.setException(e);
                            ModificationProcessRequest.this.errorHandler.error(e.getMessage(), e);
                            m.markComplete();
                            m.notifyAll();
                            break block11;
                        }
                        catch (Error e) {
                            try {
                                m.setException(e);
                                ModificationProcessRequest.this.errorHandler.error(e.getMessage(), e);
                                break block11;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                m.markComplete();
                                m.notifyAll();
                            }
                        }
                        m.markComplete();
                        m.notifyAll();
                    }
                }
            }
        });
    }
}

