/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.ConnectionJudgementType;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;

public class AddConnectionSegment
extends ModificationAdapter {
    IDiagram diagram;
    IElement connectionElement;
    IElement edgeElement;

    public AddConnectionSegment(IDiagram diagram, IElement connectionElement, IElement edgeElement) {
        super(ADD_EDGE_PRIORITY);
        this.diagram = diagram;
        this.connectionElement = connectionElement;
        this.edgeElement = edgeElement;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        DiagramMutator mutator = (DiagramMutator)this.diagram.getHint(DiagramHints.KEY_MUTATOR);
        IModelingRules modelingRules = (IModelingRules)this.diagram.getHint(DiagramModelHints.KEY_MODELING_RULES);
        Resource connectionResource = (Resource)mutator.backendObject(this.connectionElement);
        Topology.Connection bc = mutator.getConnection(this.edgeElement, EdgeVisuals.EdgeEnd.Begin);
        Topology.Connection ec = mutator.getConnection(this.edgeElement, EdgeVisuals.EdgeEnd.End);
        Resource bn = (Resource)mutator.backendObject(bc.node);
        Resource en = (Resource)mutator.backendObject(ec.node);
        IConnectionPoint bcp = ConnectionUtil.toConnectionPoint((ReadGraph)graph, bn, bc.terminal);
        IConnectionPoint ecp = ConnectionUtil.toConnectionPoint((ReadGraph)graph, en, ec.terminal);
        ConnectionJudgement judgment = (ConnectionJudgement)this.connectionElement.getHint(ElementHints.KEY_CONNECTION_TYPE);
        if (modelingRules != null) {
            if (judgment == null) {
                judgment = modelingRules.judgeConnection((ReadGraph)graph, Arrays.asList(bcp, ecp));
            }
            if (judgment.type != ConnectionJudgementType.LEGAL) {
                System.err.println("WARNING: will not create connection segment that was judged as " + judgment.type + " between " + bcp.toString((ReadGraph)graph) + " and " + ecp.toString((ReadGraph)graph));
                return;
            }
        }
        Resource beginAttachmentRelation = this.getAttachmentRelation((ReadGraph)graph, judgment, bcp, DIA.HasPlainConnector);
        Resource endAttachmentRelation = this.getAttachmentRelation((ReadGraph)graph, judgment, ecp, DIA.HasArrowConnector);
        ConnectionUtil cu = new ConnectionUtil(graph);
        Resource beginConnector = cu.getOrCreateConnector(connectionResource, bn, bc.terminal, EdgeVisuals.EdgeEnd.Begin, beginAttachmentRelation);
        Resource endConnector = cu.getOrCreateConnector(connectionResource, en, ec.terminal, EdgeVisuals.EdgeEnd.End, endAttachmentRelation);
        if (beginConnector != null && endConnector != null) {
            cu.connect(beginConnector, endConnector);
        } else {
            if (beginConnector != null) {
                cu.removeConnectionPart(beginConnector);
            }
            if (endConnector != null) {
                cu.removeConnectionPart(endConnector);
            }
        }
    }

    private Resource getAttachmentRelation(ReadGraph graph, ConnectionJudgement judgment, IConnectionPoint connectionPoint, Resource defaultValue) throws DatabaseException {
        if (judgment == null) {
            return defaultValue;
        }
        if (!(connectionPoint instanceof CPTerminal)) {
            return defaultValue;
        }
        if (judgment.attachmentRelations == null) {
            return defaultValue;
        }
        Resource attachment = judgment.attachmentRelations.get(graph, (CPTerminal)connectionPoint);
        return attachment != null ? attachment : defaultValue;
    }
}

