/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbollibrary;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.eclipse.swt.graphics.ImageData;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.ui.gfx.ImageUtils;

public class IconRenderingUtil {
    public static BufferedImage renderBufferedImage(ReadGraph graph, Resource symbolResource, int size) throws DatabaseException {
        G2DResource.getInstance((ReadGraph)graph);
        StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource.getInstance((ReadGraph)graph);
        IDiagram diagram = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
        diagram.setHint(DiagramHints.KEY_ELEMENT_RASTER_TARGET_SIZE, (Object)new Point(size, size));
        ElementClass ec = (ElementClass)graph.syncRequest(DiagramRequests.getElementClass(symbolResource, (IHintObservable)diagram));
        StaticSymbol ss = (StaticSymbol)ec.getSingleItem(StaticSymbol.class);
        Image source = ss == null ? (Image)DefaultImages.UNKNOWN2.get() : ss.getImage();
        G2DSceneGraph sceneGraph = new G2DSceneGraph();
        source.init((G2DParentNode)sceneGraph);
        BufferedImage targetImage = new BufferedImage(size, size, 2);
        Graphics2D g2d = (Graphics2D)targetImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setBackground(Color.WHITE);
        g2d.clearRect(0, 0, size, size);
        Rectangle2D bounds = source.getBounds();
        double maxB = Math.max(bounds.getWidth(), bounds.getHeight());
        double scale = (double)size / maxB;
        g2d.setTransform(new AffineTransform(scale, 0.0, 0.0, scale, -bounds.getMinX() * scale, -bounds.getMinY() * scale));
        sceneGraph.render(g2d);
        return targetImage;
    }

    public static ImageData renderIcon(ReadGraph graph, Resource symbolResource, int size) throws DatabaseException {
        BufferedImage img;
        block3: {
            try {
                img = IconRenderingUtil.renderBufferedImage(graph, symbolResource, size);
                if (img != null) break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return ImageUtils.convertToSWT((BufferedImage)img);
    }
}

